/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest.filters;

import com.atlassian.plugins.authentication.tsv.rest.annotation.OptionalBody;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;

@Provider
public class EmptyBodyFilter
implements ContainerRequestFilter {
    private static final Set<String> MUTATING_VERBS = ImmutableSet.of((Object)"POST", (Object)"PUT", (Object)"PATCH", (Object)"DELETE");
    private final I18nResolver i18nResolver;
    @Context
    private ResourceInfo resourceInfo;

    @Inject
    public EmptyBodyFilter(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public void filter(ContainerRequestContext requestContext) {
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        if (resourceMethod == null) {
            return;
        }
        if (this.isMutating(resourceMethod) && this.isBodyRequired(resourceMethod, requestContext)) {
            throw new IllegalArgumentException(this.i18nResolver.getText("authentication.rest.no.body"));
        }
    }

    private boolean hasOptionalBodyAnnotation(Method resourceMethod) {
        return resourceMethod.isAnnotationPresent(OptionalBody.class) || resourceMethod.getDeclaringClass().isAnnotationPresent(OptionalBody.class);
    }

    private boolean isBodyRequired(Method method, ContainerRequestContext requestContext) {
        boolean hasBodyParam = Arrays.stream(method.getParameters()).anyMatch(parameter -> parameter.getDeclaredAnnotations().length == 0);
        if (!hasBodyParam || this.hasOptionalBodyAnnotation(method)) {
            return false;
        }
        return !requestContext.hasEntity();
    }

    private boolean isMutating(Method method) {
        return Arrays.stream(method.getDeclaredAnnotations()).anyMatch(annotation -> MUTATING_VERBS.contains(annotation.annotationType().getSimpleName().toUpperCase(Locale.ROOT)));
    }
}

