/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest.filters.ratelimit;

import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.tsv.exception.ElevationMeansIncorrectException;
import com.atlassian.plugins.authentication.tsv.model.MethodInvocationResult;
import com.atlassian.plugins.authentication.tsv.rest.filters.ratelimit.RateLimit;
import com.atlassian.plugins.authentication.tsv.rest.filters.ratelimit.RateLimitRequestFilter;
import com.atlassian.plugins.authentication.tsv.rest.filters.ratelimit.RateLimitResponseFilter;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.atlassian.fugue.Either;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitMethodInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RateLimitMethodInterceptor.class);
    private final RateLimitRequestFilter rateLimitRequestFilter;
    private final RateLimitResponseFilter rateLimitResponseFilter;
    private final AuthenticationPluginFeatureInternalService authenticationPluginFeatureService;
    private final I18nResolver i18nResolver;
    private final UserManager userManager;

    public RateLimitMethodInterceptor(RateLimitRequestFilter rateLimitRequestFilter, RateLimitResponseFilter rateLimitResponseFilter, AuthenticationPluginFeatureInternalService authenticationPluginFeatureService, I18nResolver i18nResolver, UserManager userManager) {
        this.rateLimitRequestFilter = rateLimitRequestFilter;
        this.rateLimitResponseFilter = rateLimitResponseFilter;
        this.authenticationPluginFeatureService = authenticationPluginFeatureService;
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
    }

    public String getUserKey(@Nonnull MethodInvocation invocation) {
        RateLimit.MethodType type = invocation.getMethod().getAnnotation(RateLimit.class).value();
        return switch (type) {
            default -> throw new MatchException(null, null);
            case RateLimit.MethodType.TOTP -> (String)invocation.getArguments()[0];
            case RateLimit.MethodType.RECOVERY_CODE -> this.extractUserKey(invocation);
            case RateLimit.MethodType.PASSWORD -> this.userManager.getRemoteUserKey().getStringValue();
        };
    }

    public MethodInvocationResult getResult(@Nonnull MethodInvocation invocation) throws Throwable {
        RateLimit.MethodType type = invocation.getMethod().getAnnotation(RateLimit.class).value();
        return switch (type) {
            default -> throw new MatchException(null, null);
            case RateLimit.MethodType.TOTP -> this.getBooleanResult(invocation);
            case RateLimit.MethodType.RECOVERY_CODE -> this.getRecoverCodeResult(invocation);
            case RateLimit.MethodType.PASSWORD -> this.getPasswordResult(invocation);
        };
    }

    public Object invoke(@Nonnull MethodInvocation invocation) throws Throwable {
        if (this.authenticationPluginFeatureService.isRateLimitingDisabled()) {
            log.debug("2SV rate limiting is disabled");
            return invocation.proceed();
        }
        log.debug("Intercepting method call: {}", (Object)invocation.getMethod().getName());
        String userKey = this.getUserKey(invocation);
        this.rateLimitRequestFilter.filter(userKey);
        MethodInvocationResult result = this.getResult(invocation);
        this.rateLimitResponseFilter.filter(userKey, result.verificationPassed());
        log.debug("Returning result for intercepted method call: {}", (Object)invocation.getMethod().getName());
        if (result.exception() != null) {
            throw result.exception();
        }
        return result.result();
    }

    private MethodInvocationResult getBooleanResult(@Nonnull MethodInvocation invocation) throws Throwable {
        Object result = invocation.proceed();
        Objects.requireNonNull(result, this.i18nResolver.getText("authentication.two-step-verification.rate.limiting.verification.result.empty"));
        return new MethodInvocationResult(((Boolean)result).booleanValue(), result, null);
    }

    private MethodInvocationResult getRecoverCodeResult(@Nonnull MethodInvocation invocation) throws Throwable {
        Either result = (Either)invocation.proceed();
        Objects.requireNonNull(result, this.i18nResolver.getText("authentication.two-step-verification.rate.limiting.verification.result.empty"));
        return new MethodInvocationResult(result.isRight(), (Object)result, null);
    }

    private MethodInvocationResult getPasswordResult(@Nonnull MethodInvocation invocation) throws Throwable {
        try {
            invocation.proceed();
            return new MethodInvocationResult(true, null, null);
        }
        catch (FailedAuthenticationException | ElevationMeansIncorrectException e) {
            return new MethodInvocationResult(false, null, (Exception)e);
        }
    }

    private String extractUserKey(MethodInvocation invocation) {
        Object arg = invocation.getArguments()[0];
        if (arg instanceof UserProfile) {
            UserProfile userProfile = (UserProfile)arg;
            return userProfile.getUserKey().getStringValue();
        }
        return (String)arg;
    }
}

