/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service;

import com.atlassian.plugins.authentication.api.tsv.internal.exception.EnrollmentNotFoundException;
import com.atlassian.plugins.authentication.api.tsv.internal.service.AuthAuditService;
import com.atlassian.plugins.authentication.api.tsv.internal.service.RecoveryCodeService;
import com.atlassian.plugins.authentication.tsv.db.TotpUserEnrollmentDao;
import com.atlassian.plugins.authentication.tsv.model.TotpUserEnrollment;
import com.atlassian.plugins.authentication.tsv.service.InternalRecoveryCodeService;
import com.atlassian.plugins.authentication.tsv.service.RecoveryCodeGenerator;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserProfile;
import io.atlassian.fugue.Either;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRecoveryCodeService
implements InternalRecoveryCodeService {
    private static final Logger log = LoggerFactory.getLogger(DefaultRecoveryCodeService.class);
    private final TotpUserEnrollmentDao totpUserEnrollmentDao;
    private final RecoveryCodeGenerator recoveryCodeGenerator;
    private final AuthAuditService authAuditService;

    public DefaultRecoveryCodeService(TotpUserEnrollmentDao totpUserEnrollmentDao, RecoveryCodeGenerator recoveryCodeGenerator, AuthAuditService authAuditService) {
        this.totpUserEnrollmentDao = totpUserEnrollmentDao;
        this.recoveryCodeGenerator = recoveryCodeGenerator;
        this.authAuditService = authAuditService;
    }

    @Override
    public Either<RecoveryCodeService.RecoveryCodeConsumptionError, String> useRecoveryCode(@Nonnull UserProfile userProfile, @Nonnull String recoveryCode) {
        String username = userProfile.getUsername();
        UserKey userKey = userProfile.getUserKey();
        return this.useRecoveryCode(userKey.getStringValue(), username, recoveryCode);
    }

    @Override
    public Either<RecoveryCodeService.RecoveryCodeConsumptionError, String> useRecoveryCode(@Nonnull String userKey, @Nonnull String username, @Nonnull String recoveryCode) {
        return this.totpUserEnrollmentDao.findTotpUserEnrollmentByUserKey(userKey).map(enrollment -> {
            if (Objects.equals(enrollment.recoveryCode(), recoveryCode)) {
                log.debug("User {} provided matching recovery code, authenticating and regenerating", (Object)username);
                String newRecoveryCode = this.recoveryCodeGenerator.generateRecoveryCode();
                this.authAuditService.logRecoveryCodeRegenerated(username);
                this.totpUserEnrollmentDao.updateTotpUserEnrollment(enrollment.withRecoveryCode(newRecoveryCode));
                return Either.right((Object)newRecoveryCode);
            }
            log.debug("User {} provided an invalid recovery code", (Object)username);
            return Either.left((Object)RecoveryCodeService.RecoveryCodeConsumptionError.RECOVERY_CODE_INVALID);
        }).orElseGet(() -> {
            log.debug("User {} is not enrolled to 2SV and cannot use recovery codes", (Object)username);
            return Either.left((Object)RecoveryCodeService.RecoveryCodeConsumptionError.USER_NOT_ENROLLED);
        });
    }

    @Override
    @Nonnull
    public String rotateRecoveryCode(@Nonnull String userKey, @Nonnull String username) {
        log.debug("Rotating recovery code for user with username {} and user-key {}", (Object)username, (Object)userKey);
        return this.totpUserEnrollmentDao.findTotpUserEnrollmentByUserKey(userKey).map(enrollment -> enrollment.withRecoveryCode(this.recoveryCodeGenerator.generateRecoveryCode())).flatMap(this.totpUserEnrollmentDao::updateTotpUserEnrollment).map(TotpUserEnrollment::recoveryCode).map(newRecoveryCode -> {
            log.debug("Recovery code rotated successfully for user with username {} and user-key {}", (Object)username, (Object)userKey);
            this.authAuditService.logRecoveryCodeRegenerated(username);
            return newRecoveryCode;
        }).orElseThrow(() -> {
            log.debug("User with username {} and user-key {} is not enrolled to 2SV and cannot rotate recovery code", (Object)username, (Object)userKey);
            throw new EnrollmentNotFoundException();
        });
    }
}

