/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service;

import com.atlassian.plugins.authentication.api.tsv.service.SeenTotpCodesService;
import com.atlassian.plugins.authentication.sso.web.saml.provider.InvalidSamlResponse;
import com.atlassian.plugins.authentication.tsv.db.TotpCodesDao;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSeenTotpCodesService
implements JobRunner,
SeenTotpCodesService {
    private static final Logger log = LoggerFactory.getLogger(DefaultSeenTotpCodesService.class);
    private static final JobRunnerKey SCHEDULER_JOBRUNNER_KEY = JobRunnerKey.of((String)DefaultSeenTotpCodesService.class.getCanonicalName());
    private static final String SCHEDULER_JOB_ID = "totpCodes-cleanup";
    private static final long TOTP_CODE_LIFETIME = Long.getLong("atlassian.authentication.2sv.totp.code.lifetime", 90L);
    private final TotpCodesDao totpCodesDao;
    private final SchedulerService schedulerService;

    public DefaultSeenTotpCodesService(TotpCodesDao totpCodesDao, SchedulerService schedulerService) {
        this.totpCodesDao = totpCodesDao;
        this.schedulerService = schedulerService;
    }

    @PostConstruct
    public void registerCleanup() throws SchedulerServiceException {
        this.schedulerService.registerJobRunner(SCHEDULER_JOBRUNNER_KEY, (JobRunner)this);
        Date nextRun = Date.from(Instant.now().plus(90L, ChronoUnit.SECONDS));
        Schedule minuteSchedule = Schedule.forInterval((long)TimeUnit.SECONDS.toMillis(TOTP_CODE_LIFETIME), (Date)nextRun);
        this.schedulerService.scheduleJob(JobId.of((String)SCHEDULER_JOB_ID), JobConfig.forJobRunnerKey((JobRunnerKey)SCHEDULER_JOBRUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(minuteSchedule));
        log.debug("Scheduled minute cleanup job ({} - {}), next run at {}", new Object[]{SCHEDULER_JOBRUNNER_KEY, SCHEDULER_JOB_ID, nextRun});
    }

    @PreDestroy
    public void cancelCleanup() {
        this.schedulerService.unregisterJobRunner(SCHEDULER_JOBRUNNER_KEY);
        log.debug("Cancelled cleanup job");
    }

    public boolean validateTotpCodeUsage(@Nonnull String userKey, @Nonnull String totpCode) throws InvalidSamlResponse {
        if (this.totpCodesDao.totpCodeExistForUser(userKey, DigestUtils.sha256Hex((String)totpCode))) {
            log.debug("TOTP validation failed, the code already used by user {}", (Object)userKey);
            return false;
        }
        Instant time = Instant.now().plusSeconds(90L);
        this.totpCodesDao.saveTotpCodeForUser(DigestUtils.sha256Hex((String)totpCode), userKey, time);
        return true;
    }

    public void cleanupCodesExpiredBefore(Instant time) {
        this.totpCodesDao.removeExpiredBefore(time);
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        try {
            Instant now = Instant.now();
            log.debug("Removing TOTP codes older than {}", (Object)now);
            this.cleanupCodesExpiredBefore(now);
        }
        catch (Exception e) {
            log.error("Failed cleanup job", (Throwable)e);
            return JobRunnerResponse.failed((Throwable)e);
        }
        return JobRunnerResponse.success();
    }
}

