/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service;

import com.atlassian.plugins.authentication.tsv.db.TotpUserEnrollmentDao;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnrollmentCleanupService {
    private static final Logger log = LoggerFactory.getLogger(EnrollmentCleanupService.class);
    private final TotpUserEnrollmentDao totpUserEnrollmentDao;

    public EnrollmentCleanupService(TotpUserEnrollmentDao totpUserEnrollmentDao) {
        this.totpUserEnrollmentDao = totpUserEnrollmentDao;
    }

    protected abstract boolean isExistingUser(String var1);

    public void deleteEnrollmentsForDeletedUsers() {
        try {
            HashSet userKeysToDelete = new HashSet();
            this.totpUserEnrollmentDao.findAll(entity -> {
                String userKey = entity.getUserKey();
                if (!this.isExistingUser(userKey)) {
                    userKeysToDelete.add(userKey);
                }
            });
            for (String userKey : userKeysToDelete) {
                log.debug("Removing enrollment for deleted user {}", (Object)userKey);
                this.totpUserEnrollmentDao.removeTotpUserEnrollmentForUser(userKey);
            }
        }
        catch (Exception e) {
            log.error("Error during cleanup of enrollments for deleted users", (Throwable)e);
        }
    }
}

