/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service;

import com.atlassian.onetime.model.TOTPSecret;
import com.atlassian.plugins.authentication.api.tsv.internal.exception.EnrollmentNotFoundException;
import com.atlassian.plugins.authentication.api.tsv.internal.exception.InvalidTotpCodeException;
import com.atlassian.plugins.authentication.api.tsv.internal.service.AuthAuditService;
import com.atlassian.plugins.authentication.api.tsv.internal.service.VerificationMethod;
import com.atlassian.plugins.authentication.encryption.EncryptionService;
import com.atlassian.plugins.authentication.tsv.db.TotpUserEnrollmentDao;
import com.atlassian.plugins.authentication.tsv.exception.ConversationNotFoundException;
import com.atlassian.plugins.authentication.tsv.model.ConversationType;
import com.atlassian.plugins.authentication.tsv.model.TotpUserEnrollment;
import com.atlassian.plugins.authentication.tsv.rest.model.conversation.TotpEnrollConversation;
import com.atlassian.plugins.authentication.tsv.service.InternalTotpService;
import com.atlassian.plugins.authentication.tsv.service.RandomSecretGenerator;
import com.atlassian.plugins.authentication.tsv.service.RecoveryCodeGenerator;
import com.atlassian.plugins.authentication.tsv.service.TotpConversationService;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.model.CrowdSsoCookieData;
import com.atlassian.plugins.rest.api.security.exception.AuthenticationRequiredException;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.atlassian.fugue.Pair;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrollmentService {
    private static final Logger log = LoggerFactory.getLogger(EnrollmentService.class);
    public static final String USER_NOT_FOUND_KEY = "authentication.two-step-verification.unauthenticated.error.message";
    public static final String ALREADY_ENROLLED_TEXT_KEY = "authentication.two-step-verification.enrollment.already-enrolled";
    private final TotpConversationService totpConversationService;
    private final RecoveryCodeGenerator recoveryCodeGenerator;
    private final RandomSecretGenerator randomSecretGenerator;
    private final TotpUserEnrollmentDao totpUserEnrollmentDao;
    private final I18nResolver i18nResolver;
    private final InternalTotpService totpService;
    private final UserManager userManager;
    private final EncryptionService encryptionService;
    private final AuthAuditService authAuditService;

    public EnrollmentService(TotpConversationService totpConversationService, RecoveryCodeGenerator recoveryCodeGenerator, RandomSecretGenerator randomSecretGenerator, TotpUserEnrollmentDao totpUserEnrollmentDao, I18nResolver i18nResolver, InternalTotpService totpService, UserManager userManager, EncryptionService encryptionService, AuthAuditService authAuditService) {
        this.totpConversationService = totpConversationService;
        this.recoveryCodeGenerator = recoveryCodeGenerator;
        this.randomSecretGenerator = randomSecretGenerator;
        this.totpUserEnrollmentDao = totpUserEnrollmentDao;
        this.i18nResolver = i18nResolver;
        this.totpService = totpService;
        this.userManager = userManager;
        this.encryptionService = encryptionService;
        this.authAuditService = authAuditService;
    }

    public boolean removeTotpUserEnrollmentForUser(@Nonnull String userKey) {
        return this.totpUserEnrollmentDao.removeTotpUserEnrollmentForUser(userKey).map(enrollment -> {
            this.authAuditService.logTsvDisabled(new UserKey(userKey), VerificationMethod.TOTP);
            return true;
        }).orElse(false);
    }

    public TotpEnrollConversation startVoluntaryEnrollmentConversation() {
        UserProfile userProfile = Optional.ofNullable(this.userManager.getRemoteUser()).orElseThrow(AuthenticationRequiredException::new);
        log.debug("Starting voluntary enrollment for userKey {}", (Object)userProfile.getUserKey().getStringValue());
        return this.startEnrollmentConversation(userProfile.getUserKey().getStringValue(), userProfile.getUsername(), false, ConversationType.VOLUNTARY_ENROLLMENT, null);
    }

    public TotpEnrollConversation startChangeAuthenticationAppConversation() {
        UserProfile userProfile = Optional.ofNullable(this.userManager.getRemoteUser()).orElseThrow(AuthenticationRequiredException::new);
        String userKey = userProfile.getUserKey().getStringValue();
        String userName = userProfile.getUsername();
        if (!this.isAlreadyEnrolled(userKey)) {
            throw new EnrollmentNotFoundException();
        }
        log.debug("Starting change authentication app conversation for user-key {} ", (Object)userKey);
        TotpEnrollConversation conversation = this.createEnrollmentConversation(userKey, userName, false, ConversationType.CHANGE_AUTHENTICATION_APP, null);
        log.debug("Created change authentication app conversation for user-key {} ", (Object)userKey);
        return conversation;
    }

    private TotpEnrollConversation createEnrollmentConversation(String userKey, String userName, boolean rememberMe, ConversationType type, CrowdSsoCookieData crowdSsoCookieData) {
        TOTPSecret secret = this.randomSecretGenerator.generateSecret();
        log.debug("Secret generated for user-key {} ", (Object)userKey);
        String recoveryCode = this.recoveryCodeGenerator.generateRecoveryCode();
        log.debug("Recovery code generated for user-key {} ", (Object)userKey);
        String totpURI = this.totpService.generateTOTPUrl(userName, secret.getBase32Encoded()).toString();
        TotpEnrollConversation conversation = new TotpEnrollConversation(this.encryptionService.seal(secret.getBase32Encoded()).serialize(), recoveryCode, userKey, userName, totpURI, rememberMe, type, crowdSsoCookieData);
        this.totpConversationService.addEnrollConversation(conversation.getConversationId(), conversation);
        return conversation;
    }

    public TotpEnrollConversation startEnforcedEnrollmentConversation(@Nonnull String userKey, @Nonnull String userName, boolean rememberMe, @Nullable CrowdSsoCookieData crowdSsoCookieData) {
        return this.startEnrollmentConversation(userKey, userName, rememberMe, ConversationType.ENFORCED_ENROLLMENT, crowdSsoCookieData);
    }

    public TotpUserEnrollment completeVoluntaryEnrollment(@Nonnull String conversationId, @Nonnull String totpCode) throws ConversationNotFoundException {
        UserKey userKey = Optional.ofNullable(this.userManager.getRemoteUserKey()).orElseThrow(() -> new IllegalArgumentException(this.i18nResolver.getText(USER_NOT_FOUND_KEY)));
        TotpEnrollConversation conversation = this.getConversation(conversationId, ConversationType.VOLUNTARY_ENROLLMENT);
        log.debug("Found conversation for user-key {}", (Object)userKey.getStringValue());
        EnrollmentService.checkConversationBelongsToSameUser(conversation, userKey);
        EnrollmentService.checkConversationTypeIsExpected(conversation, ConversationType.VOLUNTARY_ENROLLMENT);
        TotpUserEnrollment enrollment = this.completeEnrollmentConversation(conversation, totpCode);
        this.authAuditService.logTsvEnabled(userKey, VerificationMethod.TOTP, false);
        return enrollment;
    }

    public Pair<TotpUserEnrollment, TotpEnrollConversation> completeEnforcedEnrollment(@Nonnull String conversationId, @Nonnull String totpCode) throws ConversationNotFoundException {
        TotpEnrollConversation conversation = this.getConversation(conversationId, ConversationType.ENFORCED_ENROLLMENT);
        log.debug("Completion of enforced enrollment for user-key {} started", (Object)conversation.getUserKey());
        EnrollmentService.checkConversationTypeIsExpected(conversation, ConversationType.ENFORCED_ENROLLMENT);
        TotpUserEnrollment totpUserEnrollment = this.completeEnrollmentConversation(conversation, totpCode);
        this.authAuditService.logTsvEnabled(new UserKey(conversation.getUserKey()), VerificationMethod.TOTP, true);
        return Pair.pair((Object)totpUserEnrollment, (Object)conversation);
    }

    public boolean isAlreadyEnrolled(@Nonnull String userKey) {
        return this.totpUserEnrollmentDao.findTotpUserEnrollmentByUserKey(userKey).isPresent();
    }

    private TotpEnrollConversation startEnrollmentConversation(@Nonnull String userKey, @Nonnull String userName, boolean rememberMe, ConversationType type, @Nullable CrowdSsoCookieData crowdSsoCookieData) {
        if (this.isAlreadyEnrolled(userKey)) {
            throw new IllegalArgumentException(this.i18nResolver.getText(ALREADY_ENROLLED_TEXT_KEY));
        }
        log.debug("Starting creation of enrollment conversation for user-key {} ", (Object)userKey);
        TotpEnrollConversation conversation = this.createEnrollmentConversation(userKey, userName, rememberMe, type, crowdSsoCookieData);
        log.debug("Created enrollment conversation for user-key {} ", (Object)userKey);
        return conversation;
    }

    private TotpUserEnrollment completeEnrollmentConversation(@Nonnull TotpEnrollConversation conversation, @Nonnull String totpCode) {
        log.debug("Completing enrollment conversation for user-key {}", (Object)conversation.getUserKey());
        if (this.isAlreadyEnrolled(conversation.getUserKey())) {
            log.error("User with user-key {} is already enrolled with TOTP", (Object)conversation.getUserKey());
            throw new IllegalArgumentException(this.i18nResolver.getText(ALREADY_ENROLLED_TEXT_KEY));
        }
        if (!this.totpService.isTotpCodeValid(conversation.getUserKey(), totpCode, conversation.getSealedSecret())) {
            log.debug("Invalid TOTP code provided by user to complete enrollment by user-key {}", (Object)conversation.getUserKey());
            throw new InvalidTotpCodeException();
        }
        TotpUserEnrollment totpUserEnrollment = new TotpUserEnrollment(conversation.getUserKey(), conversation.getSealedSecret(), conversation.getRecoveryCode(), null, null);
        totpUserEnrollment = this.totpUserEnrollmentDao.createTotpUserEnrollment(totpUserEnrollment);
        this.totpConversationService.invalidateEnrollmentConversation(conversation.getConversationId());
        log.debug("Completed enrollment conversation with for user-key {}", (Object)conversation.getUserKey());
        return totpUserEnrollment;
    }

    public TotpUserEnrollment completeChangeAuthenticationAppConversation(@Nonnull String conversationId, @Nonnull String totpCode) throws ConversationNotFoundException {
        UserKey userKey = Optional.ofNullable(this.userManager.getRemoteUserKey()).orElseThrow(() -> new IllegalArgumentException(this.i18nResolver.getText(USER_NOT_FOUND_KEY)));
        TotpEnrollConversation conversation = this.getConversation(conversationId, ConversationType.CHANGE_AUTHENTICATION_APP);
        EnrollmentService.checkConversationBelongsToSameUser(conversation, userKey);
        EnrollmentService.checkConversationTypeIsExpected(conversation, ConversationType.CHANGE_AUTHENTICATION_APP);
        log.debug("Completing change authentication app conversation for user-key {}", (Object)conversation.getUserKey());
        if (!this.totpService.isTotpCodeValid(userKey.getStringValue(), totpCode, conversation.getSealedSecret())) {
            log.debug("Invalid TOTP code provided by user to complete change authentication app by user-key {}", (Object)conversation.getUserKey());
            throw new InvalidTotpCodeException();
        }
        TotpUserEnrollment totpUserEnrollment = new TotpUserEnrollment(conversation.getUserKey(), conversation.getSealedSecret(), conversation.getRecoveryCode(), null, null);
        totpUserEnrollment = this.totpUserEnrollmentDao.updateTotpUserEnrollment(totpUserEnrollment).orElseThrow(() -> {
            log.error("User with user-key {} is not enrolled with TOTP", (Object)conversation.getUserKey());
            throw new EnrollmentNotFoundException();
        });
        this.totpConversationService.invalidateEnrollmentConversation(conversation.getConversationId());
        log.debug("Completed change authentication app conversation with for user-key {}", (Object)conversation.getUserKey());
        this.authAuditService.logChangeAuthenticationApp(conversation.getUserName(), VerificationMethod.TOTP);
        return totpUserEnrollment;
    }

    private static void checkConversationBelongsToSameUser(TotpEnrollConversation conversation, UserKey userKey) throws ConversationNotFoundException {
        if (!conversation.getUserKey().equals(userKey.getStringValue())) {
            log.error("User key {} in conversation does not match the user-key of the current logged-in user {}", (Object)conversation.getUserKey(), (Object)userKey.getStringValue());
            throw new ConversationNotFoundException(conversation.getType());
        }
    }

    private static void checkConversationTypeIsExpected(TotpEnrollConversation conversation, ConversationType expectedConversationType) throws ConversationNotFoundException {
        if (conversation.getType() != expectedConversationType) {
            log.error("User with user key {} requested completion of {} process while conversation was for {}", new Object[]{conversation.getUserKey(), conversation.getType(), expectedConversationType});
            throw new ConversationNotFoundException(expectedConversationType);
        }
    }

    private TotpEnrollConversation getConversation(@Nonnull String conversationId, ConversationType conversationType) throws ConversationNotFoundException {
        return this.totpConversationService.retrieveEnrollConversation(conversationId).orElseThrow(() -> new ConversationNotFoundException(conversationType));
    }
}

