/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service;

import com.atlassian.onetime.model.TOTPSecret;
import com.atlassian.onetime.service.SecretProvider;
import com.atlassian.plugins.authentication.tsv.service.SecureRandomProvider;
import jakarta.annotation.Nonnull;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomSecretGenerator
implements SecretProvider {
    private static final Logger log = LoggerFactory.getLogger(RandomSecretGenerator.class);
    private final SecureRandom secureRandom;

    public RandomSecretGenerator(SecureRandomProvider secureRandomProvider) {
        this.secureRandom = secureRandomProvider.getSecureRandom();
    }

    @Nonnull
    public TOTPSecret generateSecret() {
        log.debug("Generating secret");
        byte[] byteArray = new byte[20];
        this.secureRandom.nextBytes(byteArray);
        TOTPSecret secret = new TOTPSecret(byteArray);
        log.debug("Secret generated");
        return secret;
    }
}

