/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service;

import com.atlassian.plugins.authentication.tsv.service.SecureRandomProvider;
import jakarta.annotation.Nonnull;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryCodeGenerator {
    private static final Logger log = LoggerFactory.getLogger(RecoveryCodeGenerator.class);
    static final char[] VALID_CHARACTERS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    static final int CODE_LENGTH = 24;
    private final SecureRandom secureRandom;

    public RecoveryCodeGenerator(SecureRandomProvider secureRandomProvider) {
        this.secureRandom = secureRandomProvider.getSecureRandom();
    }

    @Nonnull
    public String generateRecoveryCode() {
        log.debug("Generating recovery code");
        StringBuilder codeBuilder = new StringBuilder(24);
        for (int i = 0; i < 24; ++i) {
            int randomIndex = this.secureRandom.nextInt(VALID_CHARACTERS.length);
            codeBuilder.append(VALID_CHARACTERS[randomIndex]);
        }
        log.debug("Recovery code generated successfully");
        return codeBuilder.toString();
    }
}

