/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service;

import com.atlassian.plugins.authentication.tsv.db.TotpUserEnrollmentDao;
import com.atlassian.plugins.authentication.tsv.model.Method;
import com.atlassian.plugins.authentication.tsv.model.MethodStateDTO;
import com.atlassian.plugins.authentication.tsv.model.StatusDTO;
import com.atlassian.plugins.authentication.tsv.service.enforcement.EnforcementService;
import com.atlassian.sal.api.user.UserKey;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusService {
    private static final Logger log = LoggerFactory.getLogger(StatusService.class);
    private final EnforcementService enforcementService;
    private final TotpUserEnrollmentDao totpUserEnrollmentDao;

    public StatusService(EnforcementService enforcementService, TotpUserEnrollmentDao totpUserEnrollmentDao) {
        this.enforcementService = enforcementService;
        this.totpUserEnrollmentDao = totpUserEnrollmentDao;
    }

    public StatusDTO getStatus(@Nonnull UserKey userKey) {
        log.debug("Obtaining 2SV status for user key {}.", (Object)userKey.getStringValue());
        MethodStateDTO totpState = this.getTotpState(userKey);
        return new StatusDTO(this.isTsvActive(totpState), List.of(totpState));
    }

    private MethodStateDTO getTotpState(UserKey userKey) {
        boolean isEnforced = this.enforcementService.isEnforcementRequired(userKey);
        String userKeyValue = userKey.getStringValue();
        return this.totpUserEnrollmentDao.findTotpUserEnrollmentByUserKey(userKeyValue).map(enrollment -> {
            log.debug("Retrieved TOTP enrollment for user key {}. Marking TOTP state as enabled.", (Object)userKeyValue);
            return new MethodStateDTO(Method.TOTP, true, enrollment.createdAt(), isEnforced);
        }).orElseGet(() -> {
            log.debug("Cannot find TOTP enrollment for user key {}. Marking TOTP state as disabled.", (Object)userKeyValue);
            return new MethodStateDTO(Method.TOTP, false, null, isEnforced);
        });
    }

    private boolean isTsvActive(MethodStateDTO totpState) {
        return totpState.isEnabled();
    }
}

