/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service.credentialverification;

import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.auth.ExpiredPasswordAuthenticationException;
import com.atlassian.bitbucket.auth.InactiveUserAuthenticationException;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ImmutableClientProperties;
import com.atlassian.plugins.authentication.tsv.model.LoginResult;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.AbstractCredentialVerificationService;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.CredentialValidationNoOpHttpServletRequest;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.CredentialValidationNoOpHttpServletResponse;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.CredentialVerificationException;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.model.CrowdSsoCookieData;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.model.SuccessfulCredentialVerificationResult;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.security.Principal;
import java.util.Map;

public class BitbucketCredentialVerificationService
extends AbstractCredentialVerificationService {
    static final String CROWD_SSO_TOKEN_VALUE = "stash.auth.crowd.sso.authenticated";
    static final String CROWD_SSO_COOKIE_DOMAIN = "stash.auth.crowd.sso.cookie.domain";
    static final String CROWD_SSO_COOKIE_SECURE = "stash.auth.crowd.sso.cookie.secure";
    static final String CROWD_SSO_COOKIE_SESSION_LAST_VALIDATION = "stash.auth.crowd.sso.session.last.validation";
    static final String CROWD_SSO_COOKIE_TOKEN_KEY = "stash.auth.crowd.sso.cookie.token.key";
    private final AuthenticationService authenticationService;
    private final PermissionService permissionService;
    private final CrowdHttpTokenHelper crowdHttpTokenHelper;

    public BitbucketCredentialVerificationService(AuthenticationService authenticationService, PermissionService permissionService, UserManager userManager, CrowdHttpTokenHelper crowdHttpTokenHelper) {
        super(userManager);
        this.authenticationService = authenticationService;
        this.permissionService = permissionService;
        this.crowdHttpTokenHelper = crowdHttpTokenHelper;
    }

    @Override
    @Nonnull
    public SuccessfulCredentialVerificationResult verifyCredentials(HttpServletRequest request, HttpServletResponse response, String username, String password) throws CredentialVerificationException {
        try {
            Authentication authentication = this.authenticationService.authenticate(username, password, true);
            ApplicationUser applicationUser = (ApplicationUser)authentication.getUser().orElseThrow(() -> CredentialVerificationException.userNotFound(username));
            UserKey userKey = this.resolveUserKey(username);
            CrowdSsoCookieData crowdSsoCookieData = this.handleSso(authentication, request);
            if (!this.permissionService.hasGlobalPermission(applicationUser, Permission.LICENSED_USER)) {
                throw new CredentialVerificationException(LoginResult.USER_UNLICENSED);
            }
            return new SuccessfulCredentialVerificationResult((Principal)applicationUser, userKey, crowdSsoCookieData);
        }
        catch (ExpiredPasswordAuthenticationException | InactiveUserAuthenticationException e) {
            throw new CredentialVerificationException(e, LoginResult.AUTHENTICATION_DENIED);
        }
        catch (AuthenticationException | NoSuchUserException e) {
            throw new CredentialVerificationException(e, LoginResult.AUTHENTICATION_FAILED);
        }
    }

    private CrowdSsoCookieData handleSso(Authentication authentication, HttpServletRequest request) {
        Map properties = authentication.getProperties();
        try {
            String token = this.getAndConvertProperty(properties, CROWD_SSO_TOKEN_VALUE, String.class, false);
            if (token != null) {
                this.log.debug("Crowd SSO 1.0 token found, attempting to handle SSO");
                boolean cookieSecure = Boolean.TRUE.equals(this.getAndConvertProperty(properties, CROWD_SSO_COOKIE_SECURE, Boolean.class, true));
                String lastValidation = this.getAndConvertProperty(properties, CROWD_SSO_COOKIE_SESSION_LAST_VALIDATION, String.class, true);
                String cookieTokenKey = this.getAndConvertProperty(properties, CROWD_SSO_COOKIE_TOKEN_KEY, String.class, true);
                String cookieDomain = this.getAndConvertProperty(properties, CROWD_SSO_COOKIE_DOMAIN, String.class, false);
                CredentialValidationNoOpHttpServletRequest credentialValidationHttpRequest = new CredentialValidationNoOpHttpServletRequest(request);
                CredentialValidationNoOpHttpServletResponse credentialsCheckResponse = new CredentialValidationNoOpHttpServletResponse();
                ImmutableClientProperties clientProperties = this.clientPropertiesFromBitbucketAuthProperties(lastValidation, cookieDomain, cookieTokenKey);
                CookieConfiguration cookieConfiguration = new CookieConfiguration(cookieDomain, cookieSecure, cookieTokenKey);
                this.crowdHttpTokenHelper.setCrowdToken((HttpServletRequest)credentialValidationHttpRequest, (HttpServletResponse)credentialsCheckResponse, token, (ClientProperties)clientProperties, cookieConfiguration);
                return this.getCrowdTokenCookie(credentialValidationHttpRequest, credentialsCheckResponse);
            }
            this.log.trace("Crowd SSO 1.0 token not returned from Bitbucket, skipping SSO handling");
        }
        catch (Exception e) {
            this.log.error("Skipping Crowd SSO 1.0 handling as exception was thrown when processing attributes", (Throwable)e);
        }
        return null;
    }

    @Nonnull
    private ImmutableClientProperties clientPropertiesFromBitbucketAuthProperties(String lastValidation, String cookieDomain, String cookieTokenKey) {
        return ImmutableClientProperties.builder().setSessionLastValidation(lastValidation).setSsoCookieDomainName(cookieDomain).setCookieTokenKey(cookieTokenKey).build();
    }

    private <T extends Serializable> T getAndConvertProperty(Map<String, Serializable> properties, String key, Class<T> expectedClass, boolean required) {
        Serializable objectToConvert = properties.get(key);
        if (objectToConvert == null) {
            if (required) {
                throw new IllegalArgumentException("Required property " + key + " not found in Bitbucket's SSO properties");
            }
            return null;
        }
        if (expectedClass.isInstance(objectToConvert)) {
            return (T)objectToConvert;
        }
        throw new IllegalArgumentException("Property " + key + " with value " + String.valueOf(objectToConvert) + " is not of type " + expectedClass.getName());
    }
}

