/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.service.responsebuilder;

import com.atlassian.bitbucket.Product;
import com.atlassian.plugins.authentication.tsv.model.LoginResult;
import com.atlassian.plugins.authentication.tsv.rest.model.CredentialsCheckFailedDTO;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.model.FailedLoginResponseContext;
import com.atlassian.plugins.authentication.tsv.service.responsebuilder.AbstractAuthenticationFailedResponseBuilder;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;

public class BitbucketAuthenticationFailedResponseBuilder
extends AbstractAuthenticationFailedResponseBuilder {
    public BitbucketAuthenticationFailedResponseBuilder(I18nResolver i18nResolver) {
        super(i18nResolver);
    }

    @Override
    public Response generateLoginFailedResponse(FailedLoginResponseContext context) {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.createCredentialsCheckFailedDTO(context)).build();
    }

    @Nonnull
    private CredentialsCheckFailedDTO createCredentialsCheckFailedDTO(FailedLoginResponseContext context) {
        this.checkLoginResultValid(context.loginResult());
        return switch (context.loginResult()) {
            case LoginResult.USER_UNLICENSED -> new CredentialsCheckFailedDTO(this.i18nResolver.getText("bitbucket.web.auth.notlicensed", new Serializable[]{Product.NAME}), context.captchaRequired(), context.expiredCredentials());
            default -> new CredentialsCheckFailedDTO(this.i18nResolver.getText("authentication.login.failed.invalid-credentials"), context.captchaRequired(), context.expiredCredentials());
        };
    }
}

