/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.util;

import com.atlassian.plugins.authentication.api.config.ValidationError;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class MapMultimapUtil {
    private MapMultimapUtil() {
    }

    @Nonnull
    public static Map<String, Iterable<ValidationError>> generateSingletonMap(String key, Iterable<ValidationError> values) {
        HashMap<String, Iterable<ValidationError>> map = new HashMap<String, Iterable<ValidationError>>();
        map.put(key, values);
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, Iterable<ValidationError>> convertToMap(Multimap<String, ValidationError> multimap) {
        return multimap.asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue())));
    }

    public static Multimap<String, ValidationError> convertToMultimap(Map<String, Iterable<ValidationError>> map) {
        ImmutableSetMultimap.Builder multimap = ImmutableSetMultimap.builder();
        for (Map.Entry<String, Iterable<ValidationError>> entry : map.entrySet()) {
            multimap.putAll((Object)entry.getKey(), entry.getValue());
        }
        return multimap.build();
    }
}

