/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.websudo.web;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.plugins.authentication.api.tsv.websudo.internal.TsvEnrollmentStatus;
import com.atlassian.plugins.authentication.api.tsv.websudo.internal.service.TsvWebSudoService;
import com.atlassian.plugins.authentication.sso.util.TargetUrlNormalizer;
import com.atlassian.plugins.authentication.util.SafeBasePathUtil;
import com.atlassian.plugins.authentication.websudo.web.NativeWebsudoUrlBuilder;
import com.atlassian.plugins.authentication.websudo.web.data.WebsudoDataProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AdminOnly
public class WebsudoServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(WebsudoServlet.class);
    private static final Gson GSON = new Gson();
    public static final String URL = "/plugins/servlet/atlauth-2svwebsudo";
    @VisibleForTesting
    static final String TEMPLATE_NAME = "AuthenticationPlugin.Websudo.display";
    private final SoyTemplateRenderer renderer;
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;
    private final WebsudoDataProvider websudoDataProvider;
    private final PageBuilderService pageBuilderService;
    private final TargetUrlNormalizer targetUrlNormalizer;
    private final TsvWebSudoService tsvWebSudoService;
    private final NativeWebsudoUrlBuilder nativeWebsudoUrlBuilder;

    public WebsudoServlet(SoyTemplateRenderer renderer, UserManager userManager, ApplicationProperties applicationProperties, WebsudoDataProvider websudoDataProvider, PageBuilderService pageBuilderService, TargetUrlNormalizer targetUrlNormalizer, TsvWebSudoService tsvWebSudoService, NativeWebsudoUrlBuilder nativeWebsudoUrlBuilder) {
        this.renderer = renderer;
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
        this.websudoDataProvider = websudoDataProvider;
        this.pageBuilderService = pageBuilderService;
        this.targetUrlNormalizer = targetUrlNormalizer;
        this.tsvWebSudoService = tsvWebSudoService;
        this.nativeWebsudoUrlBuilder = nativeWebsudoUrlBuilder;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (userKey == null) {
            log.debug("Anonymous user tried to access 2SV Websudo page, redirecting to home page");
            response.sendRedirect(SafeBasePathUtil.getBaseRedirectPath(this.applicationProperties));
            return;
        }
        String destination = request.getParameter("nextUrl");
        if (this.tsvWebSudoService.getEnrollmentStatus(userKey) != TsvEnrollmentStatus.ENROLLED) {
            log.debug("Unenrolled user tried to access 2SV Websudo page, redirecting to native websudo page");
            try {
                String websudoUrl = this.nativeWebsudoUrlBuilder.buildNativeWebsudoUrl(destination);
                response.sendRedirect(websudoUrl);
                return;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Could not build native Websudo URL to the requested destination", e);
            }
        }
        if (this.userManager.isAdmin(userKey)) {
            response.setContentType("text/html");
            URI normalizedDestination = this.targetUrlNormalizer.getRelativeTargetUrl(destination);
            Map<String, Object> dataMap = this.websudoDataProvider.getMap(normalizedDestination);
            this.pageBuilderService.assembler().data().requireData("com.atlassian.plugins.authentication.atlassian-authentication-plugin:websudo-data", writer -> GSON.toJson((Object)dataMap, (Appendable)writer));
            this.renderer.render((Appendable)response.getWriter(), "com.atlassian.plugins.authentication.atlassian-authentication-plugin:templates", TEMPLATE_NAME, (Map)ImmutableMap.of());
            return;
        }
        log.debug("Non-admin user tried to access 2SV Websudo page, redirecting to home page");
        response.sendRedirect(SafeBasePathUtil.getBaseRedirectPath(this.applicationProperties));
    }
}

