/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.api.service.index.IndexRecoveryService;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.cluster.NodeStatus;
import com.atlassian.confluence.core.HeartbeatManager;
import com.atlassian.confluence.plugin.descriptor.IndexRecovererModuleDescriptor;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.beans.RemoteClusterInformation;
import com.atlassian.confluence.rpc.soap.beans.RemoteNodeStatus;
import com.atlassian.confluence.rpc.soap.beans.RemoteServerInfo;
import com.atlassian.confluence.rpc.soap.services.SoapServiceHelper;
import com.atlassian.confluence.search.IndexManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.service.AnonymousUserPermissionsService;
import com.atlassian.confluence.setup.settings.DarkFeatures;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.XmlPluginArtifact;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminSoapService {
    private static final Logger log = LoggerFactory.getLogger(AdminSoapService.class);
    private IndexManager indexManager;
    private IndexRecoveryService indexRecoveryService;
    private SoapServiceHelper soapServiceHelper;
    private ClusterManager clusterManager;
    private PermissionManager permissionManager;
    private PluginAccessor pluginAccessor;
    private PluginController pluginController;
    private AnonymousUserPermissionsService anonymousUserPermissionsService;
    private HeartbeatManager heartbeatManager;
    public static final String __PARANAMER_DATA = "installPlugin java.lang.String,byte pluginFileName,pluginData \nisDarkFeatureEnabled java.lang.String key \nisPluginEnabled java.lang.String pluginKey \nisPluginInstalled java.lang.String pluginKey \nsetAnonymousUserPermissionsService com.atlassian.confluence.security.service.AnonymousUserPermissionsService anonymousUserPermissionsService \nsetClusterManager com.atlassian.confluence.cluster.ClusterManager clusterManager \nsetEnableAnonymousAccess boolean value \nsetHeartbeatManager com.atlassian.confluence.core.HeartbeatManager heartbeatManager \nsetIndexManager com.atlassian.confluence.search.IndexManager indexManager \nsetIndexRecoveryService com.atlassian.confluence.api.service.index.IndexRecoveryService indexRecoveryService \nsetPermissionManager com.atlassian.confluence.security.PermissionManager permissionManager \nsetPluginAccessor com.atlassian.plugin.PluginAccessor pluginAccessor \nsetPluginController com.atlassian.plugin.PluginController pluginController \nsetSoapServiceHelper com.atlassian.confluence.rpc.soap.services.SoapServiceHelper soapServiceHelper \nstartActivity java.lang.String,java.lang.String key,username \nstopActivity java.lang.String,java.lang.String key,username \n";

    public RemoteServerInfo getServerInfo() throws RemoteException {
        return new RemoteServerInfo();
    }

    public boolean flushIndexQueue() throws RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        log.info("Index queue flush requested");
        while (this.indexManager.isReIndexing()) {
            log.info("System is currently re-indexing, pausing before attempting index queue flush");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RemoteException((Throwable)e);
            }
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean flushSuccessful = this.indexManager.flushQueue();
        if (flushSuccessful) {
            log.info("Index queue flush completed in {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            this.refreshIndex();
        } else {
            log.warn("Failed to perform index queue flush, attempt took {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
        return flushSuccessful;
    }

    public boolean refreshIndex() {
        try {
            this.indexManager.refreshIndex();
        }
        catch (Exception e) {
            log.error("Failed to refresh index ", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean clearIndexQueue() throws RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        this.indexManager.resetIndexQueue();
        return true;
    }

    public boolean recoverIndex() throws RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        List indexRecoverers = this.pluginAccessor.getEnabledModuleDescriptorsByClass(IndexRecovererModuleDescriptor.class);
        return indexRecoverers.stream().allMatch(r -> this.indexRecoveryService.recoverIndex(r.getJournalId(), r.getIndexDirName()));
    }

    public RemoteClusterInformation getClusterInformation() {
        return new RemoteClusterInformation(this.clusterManager.getClusterInformation());
    }

    public RemoteNodeStatus[] getClusterNodeStatuses() throws RemoteException {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, PermissionManager.TARGET_APPLICATION)) {
            throw new RemoteException("Unauthorized user, not permitted to perform this operation");
        }
        ArrayList<RemoteNodeStatus> remoteNodeStatuses = new ArrayList<RemoteNodeStatus>();
        Map nodeStatuses = this.clusterManager.getNodeStatusMap();
        for (Map.Entry entry : nodeStatuses.entrySet()) {
            remoteNodeStatuses.add(new RemoteNodeStatus(((ClusterNodeInformation)entry.getKey()).getAnonymizedNodeIdentifier().hashCode(), (NodeStatus)entry.getValue()));
        }
        return remoteNodeStatuses.toArray(new RemoteNodeStatus[remoteNodeStatuses.size()]);
    }

    public boolean isDarkFeatureEnabled(String key) {
        return DarkFeatures.isDarkFeatureEnabled((String)key);
    }

    public boolean startActivity(String key, String username) throws RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        this.heartbeatManager.startActivity(key, username);
        return true;
    }

    public boolean stopActivity(String key, String username) throws RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        this.heartbeatManager.stopActivity(key, username);
        return true;
    }

    public boolean isPluginInstalled(String pluginKey) throws RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        return this.pluginAccessor.getPlugin(pluginKey) != null;
    }

    public boolean isPluginEnabled(String pluginKey) throws RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        return this.pluginAccessor.isPluginEnabled(pluginKey);
    }

    public boolean installPlugin(String pluginFileName, byte[] pluginData) throws RemoteException {
        File pluginFile;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM)) {
            throw new RemoteException("Authenticated user [" + user + "] is not a System Administrator.");
        }
        this.soapServiceHelper.assertHasValidWebSudoSession();
        int index = pluginFileName.lastIndexOf(".");
        if (index == -1) {
            throw new RemoteException("Cannot install plugin with bad filename. It must be a jar or xml file with the correct file extension.");
        }
        try {
            pluginFile = this.createTempFile(pluginFileName.substring(0, index), pluginFileName.substring(index), pluginData);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not install plugin", e);
        }
        JarPluginArtifact artifact = null;
        if (pluginFileName.endsWith(".jar")) {
            artifact = new JarPluginArtifact(pluginFile);
        } else if (pluginFileName.endsWith(".xml")) {
            artifact = new XmlPluginArtifact(pluginFile);
        }
        if (artifact != null) {
            this.pluginController.installPlugins(new PluginArtifact[]{artifact});
            return true;
        }
        return false;
    }

    private File createTempFile(String suffix, String prefix, byte[] data) throws IOException {
        File tmp = File.createTempFile(suffix, prefix);
        try (FileOutputStream fout = new FileOutputStream(tmp);){
            fout.write(data);
            fout.flush();
            fout.close();
        }
        catch (IOException ex) {
            log.error("Unable to create temporary file", (Throwable)ex);
            throw ex;
        }
        return tmp;
    }

    public boolean setEnableAnonymousAccess(boolean value) throws RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        this.anonymousUserPermissionsService.setUsePermission(value);
        return true;
    }

    public void setHeartbeatManager(HeartbeatManager heartbeatManager) {
        this.heartbeatManager = heartbeatManager;
    }

    public void setSoapServiceHelper(SoapServiceHelper soapServiceHelper) {
        this.soapServiceHelper = soapServiceHelper;
    }

    public void setIndexManager(IndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setIndexRecoveryService(IndexRecoveryService indexRecoveryService) {
        this.indexRecoveryService = indexRecoveryService;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setPluginController(PluginController pluginController) {
        this.pluginController = pluginController;
    }

    public void setAnonymousUserPermissionsService(AnonymousUserPermissionsService anonymousUserPermissionsService) {
        this.anonymousUserPermissionsService = anonymousUserPermissionsService;
    }
}

