/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.nutcluster;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.cache.nutcluster.NutclusterHelper;
import com.atlassian.nutcluster.core.IMap;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.google.common.base.Preconditions;
import java.util.function.Supplier;

@Internal
public class DefaultNutclusterHelper
implements NutclusterHelper {
    protected static final String PREFIX = "atlassian-cache.";
    protected static final String PREFIX_CACHE = "atlassian-cache.Cache.";
    protected static final String PREFIX_CACHE_REFERENCE = "atlassian-cache.CacheReference.";
    private final Supplier<NutclusterInstance> instanceSupplier;

    public DefaultNutclusterHelper(Supplier<NutclusterInstance> instanceSupplier) {
        this.instanceSupplier = (Supplier)Preconditions.checkNotNull(instanceSupplier);
    }

    public DefaultNutclusterHelper(NutclusterInstance nutclusterInstance) {
        this.instanceSupplier = () -> (NutclusterInstance)Preconditions.checkNotNull((Object)nutclusterInstance);
    }

    @Override
    public IMap getNutclusterMapForCache(String cacheName) {
        return this.instanceSupplier.get().getMap(this.getNutclusterMapNameForCache(cacheName));
    }

    @Override
    public IMap getNutclusterMapForCachedReference(String cacheName) {
        return this.instanceSupplier.get().getMap(this.getNutclusterMapNameForCachedReference(cacheName));
    }

    @Override
    public String getNutclusterMapNameForCache(String cacheName) {
        return PREFIX_CACHE + cacheName;
    }

    @Override
    public String getNutclusterMapNameForCachedReference(String cacheName) {
        return PREFIX_CACHE_REFERENCE + cacheName;
    }

    @Override
    public String getBaseSharedDataName() {
        return "confluenceNutclusterSharedData.*";
    }
}

