/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.nutcluster;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.cache.nutcluster.NutclusterHelper;
import com.atlassian.confluence.cluster.AWSClusterJoinConfig;
import com.atlassian.confluence.cluster.ClusterConfig;
import com.atlassian.confluence.cluster.ClusterJoinConfig;
import com.atlassian.confluence.cluster.KubernetesClusterJoinConfig;
import com.atlassian.confluence.cluster.MulticastClusterJoinConfig;
import com.atlassian.confluence.cluster.TCPIPClusterJoinConfig;
import com.atlassian.confluence.cluster.nutcluster.AlwaysNullMapMergePolicy;
import com.atlassian.confluence.cluster.nutcluster.LoggingClusterMembershipListener;
import com.atlassian.confluence.cluster.nutcluster.NutclusterClusterSafetyManager;
import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.confluence.impl.cluster.nutcluster.NutclusterConfigurationAccessor;
import com.atlassian.confluence.impl.cluster.nutcluster.interceptor.ClusterJoinSocketInterceptor;
import com.atlassian.confluence.impl.cluster.nutcluster.interceptor.authenticator.ClusterJoinManager;
import com.atlassian.nutcluster.aws.AwsDiscoveryStrategyFactory;
import com.atlassian.nutcluster.aws.AwsProperties;
import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.DiscoveryStrategyConfig;
import com.atlassian.nutcluster.config.EvictionPolicy;
import com.atlassian.nutcluster.config.InMemoryFormat;
import com.atlassian.nutcluster.config.InterfacesConfig;
import com.atlassian.nutcluster.config.JoinConfig;
import com.atlassian.nutcluster.config.ListenerConfig;
import com.atlassian.nutcluster.config.MapConfig;
import com.atlassian.nutcluster.config.MaxSizeConfig;
import com.atlassian.nutcluster.config.MemberAttributeConfig;
import com.atlassian.nutcluster.config.MergePolicyConfig;
import com.atlassian.nutcluster.config.NearCacheConfig;
import com.atlassian.nutcluster.config.NetworkConfig;
import com.atlassian.nutcluster.config.SerializationConfig;
import com.atlassian.nutcluster.config.SerializerConfig;
import com.atlassian.nutcluster.config.SetConfig;
import com.atlassian.nutcluster.config.SocketInterceptorConfig;
import com.atlassian.nutcluster.config.XmlConfigBuilder;
import com.atlassian.nutcluster.nio.serialization.Serializer;
import com.atlassian.nutcluster.serialization.OsgiClassLoaderRegistrySynchronizer;
import com.atlassian.nutcluster.serialization.OsgiSafe;
import com.atlassian.nutcluster.serialization.OsgiSafeStreamSerializer;
import com.atlassian.nutcluster.spi.discovery.DiscoveryStrategyFactory;
import com.atlassian.nutcluster.spi.properties.GroupProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class ConfluenceNutclusterConfigBuilder {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceNutclusterConfigBuilder.class);
    private static final int MAX_CACHE_SIZE = 25000;
    private static final String DEFAULT_CACHE_REGION_NAME = "default";
    private static final String NUTCLUSTER_DEFAULT_REGION_MAX_CACHE_SIZE = "confluence.cluster.hazelcast.default.region.max.cache.size";
    private static final String LISTEN_PORT_SYSPROP = "confluence.cluster.hazelcast.listenPort";
    private static final String MAX_HEARTBEAT = System.getProperty("confluence.cluster.hazelcast.max.no.heartbeat.seconds", "30");
    private static final String CLUSTER_INTERFACE_IP = System.getProperty("confluence.cluster.interface.ip", "");
    private static final boolean IPv6_SUPPORTED = Boolean.getBoolean("confluence.cluster.interface.ip6.support");
    private static final boolean IS_LITE_MEMBER = Boolean.getBoolean("confluence.hazelcast.litemember");
    private static final int DEFAULT_CACHE_MAP_SYNC_BACKUPS = 0;
    private static final int DEFAULT_CACHE_MAP_ASYNC_BACKUPS = 0;
    private static final int DEFAULT_NUTCLUSTER_PORT = 5801;
    private static final Collection<String> DEFAULT_OUTBOUND_PORT_DEFINITIONS = ImmutableList.of((Object)"33000-35000");
    private static final Map<String, String> DEFAULT_NUTCLUSTER_PROPERTIES = ImmutableMap.builder().put((Object)"hazelcast.logging.type", (Object)"slf4j").put((Object)"hazelcast.heartbeat.interval.seconds", (Object)"1").put((Object)"hazelcast.max.no.heartbeat.seconds", (Object)MAX_HEARTBEAT).put((Object)"hazelcast.prefer.ipv4.stack", (Object)String.valueOf(!IPv6_SUPPORTED)).put((Object)"hazelcast.operation.call.timeout.millis", (Object)"60000").put((Object)"hazelcast.map.invalidation.batch.enabled", (Object)"false").put((Object)"hazelcast.map.invalidation.batch.size", (Object)"1").put((Object)"javax.xml.transform.TransformerFactory", (Object)"com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl").put((Object)"javax.xml.validation.SchemaFactory:http://www.w3.org/2001/XMLSchema", (Object)"com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory").build();
    private static final String NUTCLUSTER_INSTANCE_NAME = "confluence";
    private final NutclusterConfigurationAccessor configurationAccessor;
    private final ClassLoader classLoader;
    private final OsgiSafeStreamSerializer osgiSafeStreamSerializer;
    private final NutclusterHelper nutclusterHelper;
    private final Consumer<Config> extraConfig;
    private final boolean devMode;
    private final ClusterJoinManager joinManager;
    private boolean isUsedNutclusterConfigOverride;

    ConfluenceNutclusterConfigBuilder(NutclusterConfigurationAccessor configurationAccessor, ClassLoader classLoader, OsgiSafeStreamSerializer osgiSafeStreamSerializer, boolean devMode, NutclusterHelper nutclusterHelper, Consumer<Config> extraConfig, ClusterJoinManager joinManager) {
        this.configurationAccessor = Objects.requireNonNull(configurationAccessor);
        this.classLoader = Objects.requireNonNull(classLoader);
        this.osgiSafeStreamSerializer = Objects.requireNonNull(osgiSafeStreamSerializer);
        this.devMode = devMode;
        this.nutclusterHelper = Objects.requireNonNull(nutclusterHelper);
        this.extraConfig = extraConfig;
        this.joinManager = joinManager;
    }

    Config createNutclusterConfig(ClusterConfig clusterConfig, String nutclusterConfigResourceName) {
        Config nutclusterConfig = this.createBaseConfig(nutclusterConfigResourceName);
        nutclusterConfig.setProperty(GroupProperty.SEARCH_DYNAMIC_CONFIG_FIRST.getName(), Boolean.TRUE.toString());
        nutclusterConfig.setProperty(GroupProperty.ENABLE_JMX.getName(), Boolean.toString(ConfluenceSystemProperties.isEnableNutclusterJMX()));
        nutclusterConfig.setInstanceName(NUTCLUSTER_INSTANCE_NAME);
        if (StringUtils.isNotBlank((CharSequence)clusterConfig.getClusterName())) {
            nutclusterConfig.setGroupConfig(nutclusterConfig.getGroupConfig().setName(clusterConfig.getClusterName()));
        } else {
            nutclusterConfig.setGroupConfig(nutclusterConfig.getGroupConfig().setName(NUTCLUSTER_INSTANCE_NAME));
        }
        nutclusterConfig.setClassLoader(this.classLoader);
        this.updateConfigInterceptors(nutclusterConfig);
        ConfluenceNutclusterConfigBuilder.configureManagementCenter(nutclusterConfig);
        ConfluenceNutclusterConfigBuilder.configureLiteMember(nutclusterConfig);
        this.extraConfig.accept(nutclusterConfig);
        this.updateNetworkConfig(clusterConfig, nutclusterConfig);
        this.updateSerializationConfig(nutclusterConfig.getSerializationConfig());
        this.updateBaseCacheDataStructureConfig(nutclusterConfig);
        this.updatePropertiesConfig(nutclusterConfig);
        this.updateListenerConfig(nutclusterConfig);
        this.updateConfiguredNodeName(nutclusterConfig);
        OsgiClassLoaderRegistrySynchronizer.configure((Config)nutclusterConfig);
        return nutclusterConfig;
    }

    private static @Nullable String getHumanReadableClusterNodeName() {
        if (ConfluenceSystemProperties.isUseHostnameAsHumanReadableClusterNodeName()) {
            return System.getenv("HOSTNAME");
        }
        return ConfluenceSystemProperties.getHumanReadableClusterNodeName();
    }

    private void updateConfiguredNodeName(Config nutclusterConfig) {
        String nodeName = ConfluenceNutclusterConfigBuilder.getHumanReadableClusterNodeName();
        if (nodeName == null) {
            return;
        }
        MemberAttributeConfig memberAttributeConfig = nutclusterConfig.getMemberAttributeConfig();
        log.info("Confluence cluster node name is [{}]", (Object)nodeName);
        memberAttributeConfig.getAttributes().put("Confluence.ConfiguredNodeName", nodeName);
    }

    private void updateListenerConfig(Config nutclusterConfig) {
        nutclusterConfig.addListenerConfig(new ListenerConfig(LoggingClusterMembershipListener.class.getName()));
    }

    private static void configureLiteMember(Config nutclusterConfig) {
        if (IS_LITE_MEMBER) {
            log.info("Configuring nutcluster node as a lite-member");
            nutclusterConfig.setLiteMember(true);
        }
    }

    private static void configureManagementCenter(Config config) {
        String managementCenterUrl = ConfluenceSystemProperties.getNutclusterManagementCenterUrl();
        if (managementCenterUrl != null) {
            config.getManagementCenterConfig().setUrl(managementCenterUrl);
            config.getManagementCenterConfig().setEnabled(true);
        }
    }

    private void updatePropertiesConfig(Config nutclusterConfig) {
        DEFAULT_NUTCLUSTER_PROPERTIES.entrySet().stream().filter(property -> !this.isPropertyAlreadySet(nutclusterConfig, (String)property.getKey())).forEach(property -> nutclusterConfig.setProperty((String)property.getKey(), (String)property.getValue()));
    }

    private void updateBaseCacheDataStructureConfig(Config nutclusterConfig) {
        if (!this.isDefaultMapConfigSet(nutclusterConfig)) {
            nutclusterConfig.addMapConfig(new MapConfig(nutclusterConfig.getMapConfig(DEFAULT_CACHE_REGION_NAME)).setMaxSizeConfig(new MaxSizeConfig(this.getDefaultRegionMaxSize(), MaxSizeConfig.MaxSizePolicy.PER_NODE)).setEvictionPolicy(EvictionPolicy.LRU));
        }
        String baseAtlassianCacheMapName = this.nutclusterHelper.getNutclusterMapNameForCache("*");
        String baseAtlassianCachedReferenceMapName = this.nutclusterHelper.getNutclusterMapNameForCachedReference("*");
        nutclusterConfig.addMapConfig(this.createMapConfig(nutclusterConfig, baseAtlassianCacheMapName, true));
        nutclusterConfig.addMapConfig(this.createMapConfig(nutclusterConfig, baseAtlassianCachedReferenceMapName, true));
        String baseSharedDataName = this.nutclusterHelper.getBaseSharedDataName();
        nutclusterConfig.addMapConfig(new MapConfig(nutclusterConfig.getMapConfig(DEFAULT_CACHE_REGION_NAME)).setName(baseSharedDataName).setBackupCount(0).setAsyncBackupCount(1).setTimeToLiveSeconds(0).setMaxIdleSeconds(0).setEvictionPolicy(EvictionPolicy.LFU).setMaxSizeConfig(new MaxSizeConfig(25000, MaxSizeConfig.MaxSizePolicy.PER_NODE)).setNearCacheConfig(null));
        nutclusterConfig.addSetConfig((SetConfig)((SetConfig)((SetConfig)new SetConfig(nutclusterConfig.getSetConfig(DEFAULT_CACHE_REGION_NAME)).setName(baseSharedDataName)).setMaxSize(25000)).setBackupCount(1));
        nutclusterConfig.addMapConfig(new MapConfig(nutclusterConfig.getMapConfig(DEFAULT_CACHE_REGION_NAME)).setName(NutclusterClusterSafetyManager.SAFETY_MAP_PREFIX + "*").setBackupCount(0).setTimeToLiveSeconds(0).setMaxIdleSeconds(0).setEvictionPolicy(EvictionPolicy.NONE).setMaxSizeConfig(new MaxSizeConfig(25000, MaxSizeConfig.MaxSizePolicy.PER_NODE)).setNearCacheConfig(null).setMergePolicyConfig(new MergePolicyConfig().setPolicy(AlwaysNullMapMergePolicy.class.getName())));
    }

    private MapConfig createMapConfig(Config nutclusterConfig, String name, boolean withNearCache) {
        NearCacheConfig nearCacheConfig = withNearCache ? new NearCacheConfig().setMaxIdleSeconds(3600).setTimeToLiveSeconds(86400).setInMemoryFormat(InMemoryFormat.OBJECT).setCacheLocalEntries(true).setInvalidateOnChange(true).setMaxSize(25000).setEvictionPolicy(EvictionPolicy.LFU.name()) : null;
        return new MapConfig(nutclusterConfig.getMapConfig(DEFAULT_CACHE_REGION_NAME)).setName(name).setBackupCount(0).setAsyncBackupCount(0).setTimeToLiveSeconds(0).setMaxIdleSeconds(0).setEvictionPolicy(EvictionPolicy.LFU).setMaxSizeConfig(new MaxSizeConfig(25000, MaxSizeConfig.MaxSizePolicy.PER_NODE)).setNearCacheConfig(nearCacheConfig);
    }

    private void updateSerializationConfig(SerializationConfig serializationConfig) {
        serializationConfig.addSerializerConfig(new SerializerConfig().setImplementation((Serializer)this.osgiSafeStreamSerializer).setTypeClass(OsgiSafe.class));
    }

    private void updateNetworkConfig(ClusterConfig confluenceClusterConfig, Config config) {
        NetworkInterface configuredNetworkInterface = confluenceClusterConfig.getNetworkInterface();
        if (configuredNetworkInterface != null) {
            ConfluenceNutclusterConfigBuilder.updateInterfacesConfig(config, configuredNetworkInterface);
        }
        this.makeConfluenceFailIfCantDiscoverClusterInterface(confluenceClusterConfig, config);
        this.updateListenPort(config.getNetworkConfig());
        ConfluenceNutclusterConfigBuilder.updateJoinConfig(confluenceClusterConfig, config);
    }

    private void makeConfluenceFailIfCantDiscoverClusterInterface(ClusterConfig confluenceClusterConfig, Config config) {
        Optional<String> networkInterfaceNameInSettingsFile = this.configurationAccessor.getClusterInterfaceName();
        if (networkInterfaceNameInSettingsFile.isPresent() && confluenceClusterConfig.getNetworkInterface() == null) {
            log.error("Confluence is not able to find network interface named {}. Please fix the network interface name in the confluence.cfg.xml file and restart Confluence", (Object)networkInterfaceNameInSettingsFile.get());
            if (this.isUsedNutclusterConfigOverride) {
                log.error("Enabling Nutcluster interfaces config. Please ensure that custom Nutcluster network settings are up to date");
            }
            config.getNetworkConfig().getInterfaces().setEnabled(true);
        }
    }

    private void updateListenPort(NetworkConfig networkConfig) {
        String portStr = System.getProperty(LISTEN_PORT_SYSPROP);
        NetworkConfig defaultNetworkConfig = new Config().getNetworkConfig();
        if (StringUtils.isNotEmpty((CharSequence)portStr)) {
            int listenPort = Integer.parseInt(portStr);
            networkConfig.setPort(listenPort);
        } else if (networkConfig.getPort() == defaultNetworkConfig.getPort()) {
            networkConfig.setPort(5801);
        }
        if (!Objects.equals(defaultNetworkConfig.getOutboundPortDefinitions(), networkConfig.getOutboundPortDefinitions())) {
            networkConfig.setOutboundPortDefinitions(DEFAULT_OUTBOUND_PORT_DEFINITIONS);
        }
        networkConfig.setPortAutoIncrement(this.devMode);
    }

    private static void updateJoinConfig(ClusterConfig confluenceClusterConfig, final Config nutclusterConfig) {
        ClusterJoinConfig clusterJoinConfig = confluenceClusterConfig.getJoinConfig();
        final JoinConfig joinConfig = nutclusterConfig.getNetworkConfig().getJoin();
        joinConfig.getMulticastConfig().setEnabled(false);
        joinConfig.getAwsConfig().setEnabled(false);
        joinConfig.getMulticastConfig().setEnabled(false);
        clusterJoinConfig.decode(new ClusterJoinConfig.Decoder(){

            public void accept(TCPIPClusterJoinConfig tcpIpJoinConfig) {
                ConfluenceNutclusterConfigBuilder.configureTcpIpJoin(joinConfig, tcpIpJoinConfig);
            }

            public void accept(MulticastClusterJoinConfig multicastJoinConfig) {
                ConfluenceNutclusterConfigBuilder.configureMulticastJoin(joinConfig, multicastJoinConfig);
            }

            public void accept(AWSClusterJoinConfig awsJoinConfig) {
                ConfluenceNutclusterConfigBuilder.configureAwsJoin(nutclusterConfig, joinConfig, awsJoinConfig);
            }

            public void accept(KubernetesClusterJoinConfig kubernetesJoinConfig) {
                ConfluenceNutclusterConfigBuilder.configureKubernetesJoin(joinConfig);
            }
        });
    }

    private static void configureKubernetesJoin(JoinConfig joinConfig) {
        joinConfig.getKubernetesConfig().setEnabled(true);
    }

    private static void configureAwsJoin(Config nutclusterConfig, JoinConfig joinConfig, AWSClusterJoinConfig awsJoinConfig) {
        AwsDiscoveryStrategyFactory awsDiscoveryStrategyFactory = new AwsDiscoveryStrategyFactory();
        HashMap<String, Comparable> properties = new HashMap<String, Comparable>();
        nutclusterConfig.getProperties().setProperty(GroupProperty.DISCOVERY_SPI_ENABLED.getName(), "true");
        Optional accessKey = awsJoinConfig.getAccessKey();
        Optional secretKey = awsJoinConfig.getSecretKey();
        awsJoinConfig.getTagKey().ifPresent(tagKey -> properties.put(AwsProperties.TAG_KEY.getDefinition().key(), (Comparable)tagKey));
        awsJoinConfig.getTagValue().ifPresent(tagValue -> properties.put(AwsProperties.TAG_VALUE.getDefinition().key(), (Comparable)tagValue));
        awsJoinConfig.getRegion().ifPresent(region -> properties.put(AwsProperties.REGION.getDefinition().key(), (Comparable)region));
        awsJoinConfig.getSecurityGroupName().ifPresent(groupName -> properties.put(AwsProperties.SECURITY_GROUP_NAME.getDefinition().key(), (Comparable)groupName));
        properties.put(AwsProperties.PORT.getDefinition().key(), Integer.valueOf(nutclusterConfig.getNetworkConfig().getPort()));
        ConfluenceNutclusterConfigBuilder.setHostHeader(properties, awsJoinConfig.getHostHeader().orElse(null), awsJoinConfig.getRegion().orElse(null));
        if (accessKey.isPresent() && secretKey.isPresent()) {
            properties.put(AwsProperties.ACCESS_KEY.getDefinition().key(), (Comparable)accessKey.get());
            properties.put(AwsProperties.SECRET_KEY.getDefinition().key(), (Comparable)secretKey.get());
        } else {
            awsJoinConfig.getIamRole().ifPresent(s -> properties.put(AwsProperties.IAM_ROLE.getDefinition().key(), (Comparable)s));
        }
        DiscoveryStrategyConfig discoveryStrategyConfig = new DiscoveryStrategyConfig((DiscoveryStrategyFactory)awsDiscoveryStrategyFactory, properties);
        joinConfig.getDiscoveryConfig().addDiscoveryStrategyConfig(discoveryStrategyConfig);
    }

    private static void configureTcpIpJoin(JoinConfig joinConfig, TCPIPClusterJoinConfig clusterJoinConfig) {
        joinConfig.getTcpIpConfig().setEnabled(true).setMembers(clusterJoinConfig.getPeerAddresses());
    }

    private static void configureMulticastJoin(JoinConfig joinConfig, MulticastClusterJoinConfig multicastClusterJoinConfig) {
        joinConfig.getMulticastConfig().setEnabled(true).setMulticastTimeToLive(multicastClusterJoinConfig.getMulticastTTL()).setMulticastGroup(multicastClusterJoinConfig.getMulticastAddress().getHostAddress()).setMulticastPort(multicastClusterJoinConfig.getMulticastPort());
    }

    private static void setHostHeader(Map<String, Comparable> awsProperties, @Nullable String hostHeader, @Nullable String region) {
        if (region != null && hostHeader == null) {
            awsProperties.put(AwsProperties.HOST_HEADER.getDefinition().key(), (Comparable)((Object)"ec2.amazonaws.com"));
        } else if (region != null) {
            awsProperties.put(AwsProperties.HOST_HEADER.getDefinition().key(), (Comparable)((Object)hostHeader.replace(region + ".", "")));
        } else if (hostHeader != null) {
            awsProperties.put(AwsProperties.HOST_HEADER.getDefinition().key(), (Comparable)((Object)hostHeader));
        }
    }

    private static void updateInterfacesConfig(Config config, NetworkInterface configuredNetworkInterface) {
        InterfacesConfig interfacesConfig = config.getNetworkConfig().getInterfaces();
        if (StringUtils.isBlank((CharSequence)CLUSTER_INTERFACE_IP)) {
            for (InetAddress networkInterfaceAddress : Collections.list(configuredNetworkInterface.getInetAddresses())) {
                interfacesConfig.addInterface(networkInterfaceAddress.getHostAddress());
            }
        } else {
            interfacesConfig.addInterface(CLUSTER_INTERFACE_IP);
            if (ConfluenceNutclusterConfigBuilder.isIpv6(CLUSTER_INTERFACE_IP)) {
                config.setProperty(GroupProperty.PREFER_IPv4_STACK.getName(), "false");
            }
        }
        interfacesConfig.setEnabled(true);
    }

    private static boolean isIpv6(String ip) {
        try {
            return InetAddress.getByName(ip) instanceof Inet6Address;
        }
        catch (Exception e) {
            log.warn("Ip address check ({}) has failed!", (Object)ip, (Object)e);
            return false;
        }
    }

    private Optional<File> getConfigOverride(String nutclusterConfigResourceName) {
        return this.configurationAccessor.getClusterSharedPath().map(path -> path.resolve("config").resolve(nutclusterConfigResourceName).toFile()).filter(File::exists);
    }

    private Config createBaseConfig(String nutclusterConfigResourceName) {
        try {
            return this.getConfigInputStream(nutclusterConfigResourceName).map(input -> new XmlConfigBuilder(input).build()).orElse(new Config());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read config", e);
        }
    }

    private Optional<InputStream> getConfigInputStream(String nutclusterConfigResourceName) throws FileNotFoundException {
        Optional<File> sharedConfig = this.getConfigOverride(nutclusterConfigResourceName);
        if (sharedConfig.isPresent()) {
            log.info("Reading Nutcluster config from shared-home location [{}]", (Object)sharedConfig.get().getAbsolutePath());
            this.isUsedNutclusterConfigOverride = true;
            return Optional.of(new FileInputStream(sharedConfig.get()));
        }
        return Optional.empty();
    }

    private boolean isPropertyAlreadySet(Config config, String propertyName) {
        Config defaultConfig = new Config();
        return !Objects.equals(defaultConfig.getProperty(propertyName), config.getProperty(propertyName));
    }

    private void updateConfigInterceptors(Config nutclusterConfig) {
        SocketInterceptorConfig interceptorConfig = new SocketInterceptorConfig();
        interceptorConfig.getProperties().put(ClusterJoinManager.class.getName(), this.joinManager);
        interceptorConfig.setClassName(ClusterJoinSocketInterceptor.class.getName());
        interceptorConfig.setEnabled(true);
        nutclusterConfig.getNetworkConfig().setSocketInterceptorConfig(interceptorConfig);
    }

    private boolean isDefaultMapConfigSet(Config nutclusterConfig) {
        return nutclusterConfig.getMapConfigs().containsKey(DEFAULT_CACHE_REGION_NAME);
    }

    private int getDefaultRegionMaxSize() {
        return Integer.getInteger(NUTCLUSTER_DEFAULT_REGION_MAX_CACHE_SIZE, 25000);
    }
}

