/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.nutcluster;

import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.core.OutOfMemoryHandler;
import com.atlassian.nutcluster.instance.OutOfMemoryErrorDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceOutOfMemoryHandler
extends OutOfMemoryHandler {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceOutOfMemoryHandler.class);

    public void onOutOfMemory(OutOfMemoryError oom, NutclusterInstance[] nutclusterInstances) {
        log.warn("OutOfMemoryError occurred attempting to continue operating as normal", (Throwable)oom);
        log.debug("Attempting to re-register {} nutcluster instances", (Object)nutclusterInstances.length);
        for (NutclusterInstance nutclusterInstance : nutclusterInstances) {
            OutOfMemoryErrorDispatcher.registerServer((NutclusterInstance)nutclusterInstance);
            log.trace("Re-registered {}", (Object)nutclusterInstance);
        }
    }
}

