/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.nutcluster;

import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.cluster.nutcluster.NutclusterUtils;
import com.atlassian.nutcluster.core.Member;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;

public class NutclusterClusterNodeInformation
implements ClusterNodeInformation {
    private final Member member;
    private final Supplier<String> nodeIdentifierRef;

    NutclusterClusterNodeInformation(Member member) {
        this.member = (Member)Preconditions.checkNotNull((Object)member);
        this.nodeIdentifierRef = Suppliers.memoize(() -> NutclusterUtils.getMemberId(member));
    }

    public InetSocketAddress getLocalSocketAddress() {
        return this.member.getSocketAddress();
    }

    public @NonNull String getAnonymizedNodeIdentifier() {
        return this.nodeIdentifierRef.get();
    }

    public @NonNull Optional<String> humanReadableNodeName() {
        return NutclusterUtils.getConfiguredMemberName(this.member);
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutclusterClusterNodeInformation that = (NutclusterClusterNodeInformation)obj;
        return Objects.equals(this.member, that.member);
    }

    public String toString() {
        return this.member.toString();
    }

    public boolean isLocal() {
        return this.member.localMember();
    }
}

