/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.nutcluster;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.serialization.OsgiClassLoaderRegistry;
import com.atlassian.nutcluster.serialization.OsgiClassLoaderRegistrySynchronizer;
import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class NutclusterOsgiListener
implements InitializingBean,
DisposableBean {
    private final EventListenerRegistrar registrar;
    private final Supplier<NutclusterInstance> instanceSupplier = () -> (NutclusterInstance)Preconditions.checkNotNull((Object)nutclusterInstance);
    private final OsgiClassLoaderRegistry osgiClassLoaderRegistry;
    private final ClusterManager clusterManager;
    private OsgiClassLoaderRegistrySynchronizer synchronizer;

    public NutclusterOsgiListener(EventListenerRegistrar registrar, NutclusterInstance nutclusterInstance, OsgiClassLoaderRegistry osgiClassLoaderRegistry, ClusterManager clusterManager) {
        this.osgiClassLoaderRegistry = (OsgiClassLoaderRegistry)Preconditions.checkNotNull((Object)osgiClassLoaderRegistry);
        this.registrar = (EventListenerRegistrar)Preconditions.checkNotNull((Object)registrar);
        this.clusterManager = clusterManager;
    }

    public void destroy() {
        if (this.isInitialized()) {
            this.registrar.unregister((Object)this.synchronizer);
        }
    }

    public void afterPropertiesSet() {
        if (this.clusterManager.isClustered()) {
            this.synchronizer = new OsgiClassLoaderRegistrySynchronizer(this.instanceSupplier.get(), this.osgiClassLoaderRegistry);
            this.registrar.register((Object)this.synchronizer);
        }
    }

    private boolean isInitialized() {
        return this.synchronizer != null;
    }
}

