/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.nutcluster;

import com.atlassian.annotations.Internal;
import com.atlassian.cluster.monitoring.spi.model.NodeIdentifier;
import com.atlassian.cluster.monitoring.spi.model.NodeInformation;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.MemberSelector;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Internal
public final class NutclusterUtils {
    public static final String CONFIGURED_NODE_NAME = "Confluence.ConfiguredNodeName";

    private NutclusterUtils() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static String getMemberId(Member member) {
        return Integer.toHexString(Objects.hash(member.getSocketAddress().getAddress(), member.getSocketAddress().getPort()));
    }

    public static NodeIdentifier getMemberNodeIdentifier(Member member) {
        return new NodeIdentifier(NutclusterUtils.getMemberId(member));
    }

    public static MemberSelector getMemberSelector(NodeIdentifier nodeIdentifier) {
        return member -> NutclusterUtils.getMemberNodeIdentifier(member).equals((Object)nodeIdentifier);
    }

    public static Function<Member, NodeIdentifier> extractNodeId() {
        return NutclusterUtils::getMemberNodeIdentifier;
    }

    public static Optional<String> getConfiguredMemberName(Member member) {
        return Optional.ofNullable(member.getStringAttribute(CONFIGURED_NODE_NAME));
    }

    public static Function<Member, NodeInformation> extractNodeInfo() {
        return member -> {
            InetSocketAddress socketAddress = member.getSocketAddress();
            String hostAddress = String.format("%s:%s", socketAddress.getAddress().getHostAddress(), socketAddress.getPort());
            return new NodeInformation(NutclusterUtils.extractNodeId().apply((Member)member), hostAddress, socketAddress.getAddress().getHostName(), (Maybe)Option.option((Object)member.getStringAttribute(CONFIGURED_NODE_NAME)));
        };
    }
}

