/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.nutcluster.monitoring;

import com.atlassian.annotations.Internal;
import com.atlassian.cluster.monitoring.spi.ClusterMonitoring;
import com.atlassian.cluster.monitoring.spi.model.MonitoringError;
import com.atlassian.cluster.monitoring.spi.model.NodeIdentifier;
import com.atlassian.cluster.monitoring.spi.model.NodeInformation;
import com.atlassian.cluster.monitoring.spi.model.Table;
import com.atlassian.confluence.cluster.nutcluster.NutclusterUtils;
import com.atlassian.confluence.cluster.nutcluster.monitoring.NutclusterLifecycleListener;
import com.atlassian.confluence.cluster.nutcluster.monitoring.NutclusterMembershipListener;
import com.atlassian.confluence.cluster.nutcluster.monitoring.RemoteModuleCallable;
import com.atlassian.diagnostics.MonitoringService;
import com.atlassian.diagnostics.Severity;
import com.atlassian.diagnostics.internal.InitializingMonitor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.nutcluster.core.IExecutorService;
import com.atlassian.nutcluster.core.LifecycleListener;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.MembershipListener;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.plugin.ModuleCompleteKey;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Either;
import jakarta.annotation.PreDestroy;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class NutclusterClusterMonitoring
extends InitializingMonitor
implements ClusterMonitoring {
    static final int MEMBER_ADDED_ID = 1001;
    static final int MEMBER_REMOVED_ID = 1002;
    private static final Logger log = LoggerFactory.getLogger(NutclusterClusterMonitoring.class);
    private static final long TIMEOUT_DURATION = 5L;
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.SECONDS;
    private static final String MONITORING_EXECUTOR_KEY = "cluster-monitoring-executor";
    private static final String MONITOR_ID = "NUTCLUSTER";
    private final NutclusterInstance nutclusterInstance;
    private final IExecutorService executor;
    private final EventPublisher eventPublisher;
    private volatile MonitoringService monitoringService;

    public NutclusterClusterMonitoring(NutclusterInstance nutclusterInstance, EventPublisher eventPublisher) {
        this.nutclusterInstance = (NutclusterInstance)Preconditions.checkNotNull((Object)nutclusterInstance);
        this.executor = (IExecutorService)Preconditions.checkNotNull((Object)this.nutclusterInstance.getExecutorService(MONITORING_EXECUTOR_KEY));
        this.eventPublisher = eventPublisher;
    }

    @PreDestroy
    public void preDestroy() {
        if (this.monitoringService != null) {
            this.monitoringService.destroyMonitor(MONITOR_ID);
        }
        log.debug("{} monitor has been destroyed", (Object)MONITOR_ID);
    }

    public Either<MonitoringError, NodeIdentifier> getCurrentNode() {
        Member member = this.nutclusterInstance.getCluster().getLocalMember();
        return Either.right((Object)NutclusterUtils.extractNodeId().apply(member));
    }

    public Either<MonitoringError, List<NodeInformation>> getNodes() {
        Set members = this.nutclusterInstance.getCluster().getMembers();
        List nodeInfos = members.stream().map(NutclusterUtils.extractNodeInfo()).sorted().collect(Collectors.toList());
        return Either.right(nodeInfos);
    }

    public @NonNull Either<MonitoringError, Table> getData(ModuleCompleteKey key, NodeIdentifier nodeId) {
        try {
            Future future = this.executor.submit((Callable)new RemoteModuleCallable(key), NutclusterUtils.getMemberSelector(nodeId));
            return Either.right((Object)((Table)future.get(5L, TIMEOUT_UNIT)));
        }
        catch (Exception e) {
            log.warn("Exception happened when receiving response from node {}", (Object)nodeId, (Object)e);
            MonitoringError error = new MonitoringError(e.getMessage());
            return Either.left((Object)error);
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean isDataCenterLicensed() {
        return true;
    }

    public boolean enableClustering() {
        return false;
    }

    public boolean isClusterSetupEnabled() {
        return false;
    }

    public void init(MonitoringService monitoringService) {
        this.monitoringService = monitoringService;
        this.monitor = monitoringService.createMonitor(MONITOR_ID, "diagnostics.hazelcast.name", () -> true);
        this.defineIssue("diagnostics.hazelcast.issue", 1001, Severity.INFO);
        this.defineIssue("diagnostics.hazelcast.issue", 1002, Severity.WARNING);
        this.nutclusterInstance.getCluster().addMembershipListener((MembershipListener)new NutclusterMembershipListener(this.monitor, this.eventPublisher));
        this.nutclusterInstance.getLifecycleService().addLifecycleListener((LifecycleListener)new NutclusterLifecycleListener(this.monitor));
        log.debug("{} monitor has been initialized", (Object)MONITOR_ID);
    }
}

