/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.nutcluster.monitoring;

import com.atlassian.confluence.cluster.nutcluster.monitoring.NutclusterMemberAddedAnalyticsEvent;
import com.atlassian.confluence.cluster.nutcluster.monitoring.NutclusterMemberRemovedAnalyticsEvent;
import com.atlassian.diagnostics.AlertRequest;
import com.atlassian.diagnostics.ComponentMonitor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.nutcluster.core.InitialMembershipEvent;
import com.atlassian.nutcluster.core.InitialMembershipListener;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.MemberAttributeEvent;
import com.atlassian.nutcluster.core.MembershipEvent;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NutclusterMembershipListener
implements InitialMembershipListener {
    private static final Logger log = LoggerFactory.getLogger(NutclusterMembershipListener.class);
    private final ComponentMonitor monitor;
    private final EventPublisher eventPublisher;

    NutclusterMembershipListener(ComponentMonitor monitor, EventPublisher eventPublisher) {
        this.monitor = Objects.requireNonNull(monitor);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
    }

    public void memberAdded(MembershipEvent event) {
        log.info("memberAdded: {}", (Object)event.getMember());
        for (Member member : event.getMembers()) {
            log.info("memberAdded: cluster contains {}", (Object)member.toString());
        }
        this.alertMembershipChange(1001, event);
        this.eventPublisher.publish((Object)new NutclusterMemberAddedAnalyticsEvent(event.getMembers().size()));
    }

    public void memberRemoved(MembershipEvent event) {
        log.info("memberRemoved: {}", (Object)event.getMember());
        for (Member member : event.getMembers()) {
            log.info("memberRemoved: cluster contains {}", (Object)member.toString());
        }
        this.alertMembershipChange(1002, event);
        this.eventPublisher.publish((Object)new NutclusterMemberRemovedAnalyticsEvent(event.getMembers().size()));
    }

    public void memberAttributeChanged(MemberAttributeEvent event) {
        log.info("memberAttributeChanged: member {}, key {}, value {}", new Object[]{event.getMember(), event.getKey(), event.getValue()});
    }

    public void init(InitialMembershipEvent event) {
        log.info("init: cluster {}", (Object)event.getCluster());
        for (Member member : event.getMembers()) {
            log.info("init: cluster contains {}", (Object)member.toString());
        }
    }

    private void alertMembershipChange(int issueId, MembershipEvent event) {
        if (this.monitor != null && this.monitor.isEnabled()) {
            this.monitor.getIssue(issueId).ifPresent(issue -> this.monitor.alert(new AlertRequest.Builder(issue).timestamp(Instant.now()).details(() -> ImmutableMap.of((Object)"member", (Object)event.getMember().toString())).build()));
        }
    }
}

