/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cache.nutcluster;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsDefaultsProvider;
import com.atlassian.cache.nutcluster.NutclusterCacheManager;
import com.atlassian.confluence.cache.nutcluster.AsyncInvalidationCacheFactory;
import com.atlassian.nutcluster.core.NutclusterInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfluenceNutclusterCacheManager
extends NutclusterCacheManager {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceNutclusterCacheManager.class);
    private final AsyncInvalidationCacheFactory asyncInvalidationCacheFactory;

    public ConfluenceNutclusterCacheManager(NutclusterInstance nutcluster, CacheFactory localCacheFactory, CacheSettingsDefaultsProvider settingsDefaultsProvider, AsyncInvalidationCacheFactory asyncInvalidationCacheFactory) {
        super(nutcluster, localCacheFactory, settingsDefaultsProvider);
        this.asyncInvalidationCacheFactory = asyncInvalidationCacheFactory;
    }

    protected <K, V> Cache<K, V> createAsyncHybridCache(String cacheName, CacheLoader<K, V> loader, CacheSettings settings) {
        return this.asyncInvalidationCacheFactory.createInvalidationCache(cacheName, loader, settings);
    }

    protected <K, V> Cache<K, V> createDistributedCache(String name, CacheLoader<K, V> loader, CacheSettings settings) {
        if (settings.getReplicateAsynchronously(false) && this.asyncInvalidationCacheFactory.isReplicatedCacheSupported(name)) {
            log.warn("Creating experimental asynchronous replicate-via-copy cache [{}]", (Object)name);
            return this.asyncInvalidationCacheFactory.createReplicatedCache(name, loader, settings);
        }
        log.warn("Creating replicate-via-copy cache [{}]. These cache are non-performant. Prefer replicate-via-invalidation instead.", (Object)name);
        return super.createDistributedCache(name, loader, settings);
    }
}

