/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cache.nutcluster.hibernate;

import com.atlassian.cache.CacheSettingsDefaultsProvider;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.hibernate.NutclusterLocalCacheRegionFactory;
import com.atlassian.nutcluster.hibernate.RegionCache;
import com.atlassian.nutcluster.hibernate.local.LocalRegionCache;
import com.atlassian.nutcluster.hibernate.local.TimestampsRegionCache;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Supplier;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.support.RegionNameQualifier;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class ConfluenceNutclusterLocalCacheRegionFactory
extends NutclusterLocalCacheRegionFactory {
    private static final long serialVersionUID = 5547443299912282834L;
    private static final int DEFAULT_CACHE_SIZE = 25000;
    private static final long DEFAULT_CACHE_TTL = 3600000L;
    private final transient CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider;

    public ConfluenceNutclusterLocalCacheRegionFactory(Supplier<NutclusterInstance> nutclusterInstanceSupplier, CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider) {
        this.instance = nutclusterInstanceSupplier.get();
        this.cacheSettingsDefaultsProvider = cacheSettingsDefaultsProvider;
    }

    protected RegionCache createRegionCache(String unqualifiedRegionName, SessionFactoryImplementor sessionFactory, DomainDataRegionConfig regionConfig) {
        this.verifyStarted();
        assert (!RegionNameQualifier.INSTANCE.isQualified(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions()));
        boolean WITH_TOPIC = true;
        String qualifiedRegionName = RegionNameQualifier.INSTANCE.qualify(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions());
        return new LocalRegionCache((RegionFactory)this, qualifiedRegionName, this.instance, regionConfig, true, (LocalRegionCache.EvictionConfig)new DynamicEvictionConfig(this.cacheSettingsDefaultsProvider, unqualifiedRegionName));
    }

    protected RegionCache createTimestampsRegionCache(String unqualifiedRegionName, SessionFactoryImplementor sessionFactory) {
        this.verifyStarted();
        assert (!RegionNameQualifier.INSTANCE.isQualified(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions()));
        String qualifiedRegionName = RegionNameQualifier.INSTANCE.qualify(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions());
        return new TimestampsRegionCache((RegionFactory)this, qualifiedRegionName, this.instance);
    }

    public static class DynamicEvictionConfig
    implements LocalRegionCache.EvictionConfig {
        private final CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider;
        private final String name;

        public DynamicEvictionConfig(CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider, String name) {
            this.cacheSettingsDefaultsProvider = cacheSettingsDefaultsProvider;
            this.name = name;
        }

        public Duration getTimeToLive() {
            Optional<Long> expireAfterWrite = Optional.ofNullable(this.cacheSettingsDefaultsProvider.getDefaults(this.name).getExpireAfterWrite());
            return Duration.of(expireAfterWrite.orElse(3600000L), ChronoUnit.MILLIS);
        }

        public int getMaxSize() {
            Optional<Integer> maxEntries = Optional.ofNullable(this.cacheSettingsDefaultsProvider.getDefaults(this.name).getMaxEntries());
            return maxEntries.orElse(25000);
        }
    }
}

