/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cluster.nutcluster.event;

import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.impl.cluster.event.TopicEvent;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

final class NutclusterTopicEvent
implements DataSerializable,
TopicEvent {
    private UUID id;
    private Object payload;

    public NutclusterTopicEvent() {
    }

    public NutclusterTopicEvent(Object payload) {
        this.id = UUID.randomUUID();
        this.payload = Objects.requireNonNull(payload);
    }

    public String toString() {
        Object object = this.payload;
        if (object instanceof ClusterEventWrapper) {
            ClusterEventWrapper wrapper = (ClusterEventWrapper)object;
            return String.format("%s %s wrapping %s", this.payload.getClass().getSimpleName(), this.id, wrapper.getEvent().getClass().getSimpleName());
        }
        return String.format("%s %s ", this.payload.getClass().getSimpleName(), this.id);
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.id);
        out.writeObject(this.payload);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.id = (UUID)in.readObject();
        this.payload = in.readObject();
    }

    public UUID getId() {
        return this.id;
    }

    public Object getPayload() {
        return this.payload;
    }
}

