/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cluster.nutcluster.event;

import com.atlassian.confluence.impl.cluster.event.TopicEventCluster;
import com.atlassian.confluence.impl.cluster.nutcluster.event.NutclusterTopicEvent;
import com.atlassian.nutcluster.core.ITopic;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.MembershipAdapter;
import com.atlassian.nutcluster.core.MembershipEvent;
import com.atlassian.nutcluster.core.MembershipListener;
import com.atlassian.nutcluster.core.NutclusterInstance;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NutclusterTopicEventCluster
implements TopicEventCluster<NutclusterTopicEvent, Member> {
    static final String TOPIC_PREFIX = NutclusterTopicEventCluster.class.getName();
    private static final Logger log = LoggerFactory.getLogger(NutclusterTopicEventCluster.class);
    private final NutclusterInstance nutcluster;
    private final Collection<Runnable> shutdownTasks = new ArrayList<Runnable>();

    public NutclusterTopicEventCluster(NutclusterInstance nutcluster) {
        this.nutcluster = nutcluster;
    }

    public void initialise(BiConsumer<Member, NutclusterTopicEvent> eventListener, BiConsumer<Member, UUID> ackListener, Consumer<Member> nodeRemovedListener) {
        this.registerTopicListener(this.eventTopic(), eventListener);
        this.registerTopicListener(this.ackTopic(), ackListener);
        this.registerClusterNodeRemovedListener(nodeRemovedListener);
    }

    <T> void registerTopicListener(ITopic<T> topic, BiConsumer<Member, T> listener) {
        log.debug("Registering listener for topic {}", (Object)topic.getName());
        String listenerId = topic.addMessageListener(message -> {
            if (!message.getPublishingMember().localMember()) {
                listener.accept(message.getPublishingMember(), message.getMessageObject());
            }
        });
        this.shutdownTasks.add(() -> topic.removeMessageListener(listenerId));
    }

    void registerClusterNodeRemovedListener(final Consumer<Member> action) {
        String id = this.nutcluster.getCluster().addMembershipListener((MembershipListener)new MembershipAdapter(this){

            public void memberRemoved(MembershipEvent event) {
                action.accept(event.getMember());
            }
        });
        this.shutdownTasks.add(() -> this.nutcluster.getCluster().removeMembershipListener(id));
    }

    public Set<Member> getOtherClusterMembers() {
        return this.nutcluster.getCluster().getMembers().stream().filter(member -> !member.localMember()).collect(Collectors.toSet());
    }

    public void publishEvent(NutclusterTopicEvent event) {
        this.eventTopic().publish((Object)event);
    }

    public void publishAck(UUID ack) {
        this.ackTopic().publish((Object)ack);
    }

    public NutclusterTopicEvent wrapEvent(Object event) {
        return new NutclusterTopicEvent(event);
    }

    @PreDestroy
    void dispose() {
        this.shutdownTasks.forEach(Runnable::run);
    }

    private ITopic<NutclusterTopicEvent> eventTopic() {
        return this.nutcluster.getTopic(TOPIC_PREFIX + ".events");
    }

    private ITopic<UUID> ackTopic() {
        return this.nutcluster.getTopic(TOPIC_PREFIX + ".acks");
    }
}

