/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cluster.nutcluster.interceptor;

import com.atlassian.confluence.impl.cluster.nutcluster.interceptor.authenticator.ClusterJoinManager;
import com.atlassian.confluence.impl.cluster.nutcluster.interceptor.authenticator.ClusterJoinMode;
import com.atlassian.confluence.impl.cluster.nutcluster.interceptor.authenticator.ClusterJoinRequest;
import com.atlassian.confluence.impl.cluster.nutcluster.interceptor.authenticator.ParanoidObjectDataInputStream;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.core.NutclusterInstanceAware;
import com.atlassian.nutcluster.instance.NutclusterInstanceImpl;
import com.atlassian.nutcluster.internal.serialization.InternalSerializationService;
import com.atlassian.nutcluster.internal.serialization.impl.ObjectDataInputStream;
import com.atlassian.nutcluster.internal.serialization.impl.ObjectDataOutputStream;
import com.atlassian.nutcluster.nio.MemberSocketInterceptor;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusterJoinSocketInterceptor
implements MemberSocketInterceptor,
NutclusterInstanceAware {
    private static final Logger log = LoggerFactory.getLogger(ClusterJoinSocketInterceptor.class);
    private ClusterJoinManager clusterJoinManager;
    private NutclusterInstance nutcluster;

    public void init(Properties properties) {
        this.clusterJoinManager = (ClusterJoinManager)properties.get(ClusterJoinManager.class.getName());
    }

    public void onAccept(Socket socket) throws IOException {
        this.clusterJoinManager.accept(new SocketClusterJoinRequest(socket, this.nutcluster, ClusterJoinMode.ACCEPT));
    }

    public void onConnect(Socket socket) throws IOException {
        this.clusterJoinManager.connect(new SocketClusterJoinRequest(socket, this.nutcluster, ClusterJoinMode.CONNECT));
    }

    public void setNutclusterInstance(NutclusterInstance nutcluster) {
        this.nutcluster = nutcluster;
    }

    static final class SocketClusterJoinRequest
    implements ClusterJoinRequest {
        private final ClusterJoinMode joinMode;
        private final NutclusterInstance nutcluster;
        private final ObjectDataInputStream in;
        private final ObjectDataOutputStream out;
        private final String localAddress;
        private final String remoteAddress;
        private final int localPort;
        private final int remotePort;

        SocketClusterJoinRequest(Socket socket, NutclusterInstance nutcluster, ClusterJoinMode joinMode) throws IOException {
            this.joinMode = joinMode;
            this.nutcluster = nutcluster;
            InternalSerializationService serializationService = ((NutclusterInstanceImpl)nutcluster).getSerializationService();
            this.in = new ParanoidObjectDataInputStream(socket.getInputStream(), serializationService);
            this.out = new ObjectDataOutputStream(socket.getOutputStream(), serializationService);
            SocketAddress localSocket = socket.getLocalSocketAddress();
            if (localSocket instanceof InetSocketAddress) {
                InetSocketAddress localInetSocket = (InetSocketAddress)localSocket;
                this.localAddress = localInetSocket.getAddress().getHostAddress();
                this.localPort = localInetSocket.getPort();
            } else {
                log.warn("Local socket address not an InetSocketAddress: {}", (Object)localSocket);
                this.localAddress = localSocket.toString();
                this.localPort = localSocket.hashCode();
            }
            SocketAddress remoteSocket = socket.getRemoteSocketAddress();
            if (remoteSocket instanceof InetSocketAddress) {
                InetSocketAddress remoteInetSocket = (InetSocketAddress)remoteSocket;
                this.remoteAddress = remoteInetSocket.getAddress().getHostAddress();
                this.remotePort = remoteInetSocket.getPort();
            } else {
                log.warn("Remote socket address not an InetSocketAddress: {}", (Object)remoteSocket);
                this.remoteAddress = remoteSocket.toString();
                this.remotePort = remoteSocket.hashCode();
            }
        }

        @Override
        public @NonNull NutclusterInstance getNutcluster() {
            return this.nutcluster;
        }

        @Override
        public @NonNull ClusterJoinMode getJoinMode() {
            return this.joinMode;
        }

        @Override
        public @NonNull String getLocalAddress() {
            return this.localAddress;
        }

        @Override
        public int getLocalPort() {
            return this.localPort;
        }

        @Override
        public @NonNull String getRemoteAddress() {
            return this.remoteAddress;
        }

        @Override
        public int getRemotePort() {
            return this.remotePort;
        }

        @Override
        public @NonNull ObjectDataInput in() {
            return this.in;
        }

        @Override
        public @NonNull ObjectDataOutput out() {
            return this.out;
        }

        public String toString() {
            return String.valueOf((Object)this.joinMode) + "(" + this.localAddress + ":" + this.localPort + (this.joinMode == ClusterJoinMode.ACCEPT ? " <- " : " -> ") + this.remoteAddress + ":" + this.remotePort + ")";
        }
    }
}

