/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.batch.descriptor;

import com.atlassian.confluence.notifications.batch.service.BatchingProcessor;
import com.atlassian.confluence.notifications.impl.descriptors.AbstractParticipantDescriptor;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class NotificationBatchingDescriptor
extends AbstractParticipantDescriptor<BatchingProcessor> {
    private ModuleCompleteKey notificationKey;

    public NotificationBatchingDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    protected void validate(Element element) {
        super.validate(element);
        if (element.attributeValue("for-notification") == null) {
            throw new ValidationException("There were validation errors:", List.of("Missing attribute [for-notification=\"pluginKey:moduleCompleteKey\"] denoting the moduleKey of the notification that this notification batching processor is used for, e.g. [for-notification=\"email-notification-plugin:page-created-notification\"], on"));
        }
    }

    public void init(@NonNull Plugin plugin, @NonNull Element descriptor) throws PluginParseException {
        super.init(plugin, descriptor);
        try {
            this.notificationKey = new ModuleCompleteKey(descriptor.attributeValue("for-notification"));
        }
        catch (IllegalArgumentException ignored) {
            this.notificationKey = new ModuleCompleteKey(this.getPluginKey(), descriptor.attributeValue("for-notification"));
        }
    }

    public ModuleCompleteKey getNotificationKey() {
        return this.notificationKey;
    }
}

