/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.batch.service;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.notifications.batch.service.BatchTarget;
import com.atlassian.confluence.notifications.batch.service.BatchingRoleRecipient;
import com.atlassian.confluence.notifications.batch.template.BatchSection;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import java.util.List;
import java.util.Optional;

@ExperimentalApi
public interface BatchSectionProvider<CONTEXT> {
    default public BatchOutput handle(BatchingRoleRecipient recipient, List<CONTEXT> context) {
        return new BatchOutput();
    }

    default public BatchOutput handle(BatchingRoleRecipient recipient, List<CONTEXT> context, ServerConfiguration serverConfiguration) {
        return this.handle(recipient, context);
    }

    @Deprecated
    default public Class<?> getPayloadType() {
        return null;
    }

    public static class BatchOutput {
        private final BatchSection section;
        private final BatchTarget target;

        public BatchOutput(BatchSection section, BatchTarget target) {
            this.section = section;
            this.target = target;
        }

        public BatchOutput() {
            this(null, null);
        }

        public Optional<BatchSection> optionalSection() {
            return Optional.ofNullable(this.section);
        }

        public Optional<BatchTarget> optionalTarget() {
            return Optional.ofNullable(this.target);
        }
    }
}

