/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.copyspace.api.event.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.confluence.plugin.copyspace.api.event.ExecutionFailureDescriptor;
import com.atlassian.confluence.plugin.copyspace.api.event.analytics.CopySpaceLifecycleEvent;
import com.atlassian.event.api.AsynchronousPreferred;
import java.time.Duration;
import java.time.Instant;

@AsynchronousPreferred
@EventName(value="confluence.confluence-copyspace.failed")
public class CopySpaceFailedEvent
extends CopySpaceLifecycleEvent {
    private final long durationInMillis;
    private final String failedStage;
    private final String reason;

    public CopySpaceFailedEvent(String operationUUID, long originalSpaceId, String originalSpaceKey, boolean copyComments, boolean copyLabels, boolean copyAttachments, boolean keepMetaData, boolean preserveWatchers, boolean copyBlogposts, boolean copyPages, int pagesCount, int commentsCount, int blogPostsCount, int attachmentsCount, Instant startTimestamp, ExecutionFailureDescriptor failureDescriptor) {
        super(operationUUID, originalSpaceId, originalSpaceKey, copyComments, copyLabels, copyAttachments, keepMetaData, preserveWatchers, copyBlogposts, copyPages, pagesCount, commentsCount, blogPostsCount, attachmentsCount);
        this.durationInMillis = Duration.between(startTimestamp, Instant.now()).toMillis();
        this.failedStage = failureDescriptor.getStage().toString();
        this.reason = failureDescriptor.getReason().toString();
    }

    public long getDurationInMillis() {
        return this.durationInMillis;
    }

    public String getFailedStage() {
        return this.failedStage;
    }

    public String getReason() {
        return this.reason;
    }
}

