/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.setup;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.setup.SetupPersister;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.impl.setup.ReadOnlyApplicationConfig;
import com.atlassian.confluence.impl.setup.ReadOnlySetupPersister;
import com.atlassian.confluence.setup.BootstrapStatusProvider;
import io.atlassian.util.concurrent.Lazy;
import java.sql.Connection;
import java.util.function.Supplier;

public class BootstrapStatusProviderImpl
implements BootstrapStatusProvider {
    private static final Supplier<BootstrapStatusProvider> instance = Lazy.supplier(() -> new BootstrapStatusProviderImpl(BootstrapUtils.getBootstrapManager()));
    private final AtlassianBootstrapManager delegate;

    @VisibleForTesting
    BootstrapStatusProviderImpl(AtlassianBootstrapManager bootstrapManager) {
        this.delegate = bootstrapManager;
    }

    public static BootstrapStatusProvider getInstance() {
        return instance.get();
    }

    @Override
    public boolean isSetupComplete() {
        return this.delegate.isSetupComplete();
    }

    @Override
    public boolean isBootstrapped() {
        return this.delegate.isBootstrapped();
    }

    @Override
    public Object getProperty(String key) {
        return this.delegate.getProperty(key);
    }

    @Override
    public String getHibernateDialect() {
        return this.delegate.getString("hibernate.dialect");
    }

    @Override
    public String getWebAppContextPath() {
        return this.delegate.getString("confluence.webapp.context.path");
    }

    @Override
    public boolean isWebAppContextPathSet() {
        return this.getWebAppContextPath() != null;
    }

    @Override
    public ApplicationConfiguration getApplicationConfig() {
        return new ReadOnlyApplicationConfig(this.delegate.getApplicationConfig());
    }

    @Override
    public SetupPersister getSetupPersister() {
        return new ReadOnlySetupPersister(this.delegate.getSetupPersister());
    }

    @Override
    public String getFilePathProperty(String var1) {
        return this.delegate.getFilePathProperty(var1);
    }

    @Override
    public String getApplicationHome() {
        return this.delegate.getApplicationHome();
    }

    @Override
    public boolean databaseContainsExistingData(Connection var1) {
        return this.delegate.databaseContainsExistingData(var1);
    }
}

