/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.license;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.internal.license.LicenseServiceInternal;
import com.atlassian.confluence.internal.license.store.LicenseStoreInternal;
import com.atlassian.confluence.license.exception.EmptyLicenseValidationException;
import com.atlassian.confluence.license.exception.ForgedLicenseException;
import com.atlassian.confluence.license.exception.InvalidLicenseException;
import com.atlassian.confluence.license.exception.KnownConfluenceLicenseValidationException;
import com.atlassian.confluence.license.exception.MissingConfluenceLicenseValidationException;
import com.atlassian.confluence.license.validator.LicenseValidator;
import com.atlassian.crowd.embedded.spi.DcLicenseChecker;
import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.LicenseException;
import com.atlassian.extras.api.LicenseManager;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.extras.core.AtlassianLicenseFactory;
import com.atlassian.extras.core.DefaultAtlassianLicenseFactory;
import com.atlassian.extras.core.confluence.ConfluenceProductLicenseFactory;
import com.atlassian.extras.decoder.api.LicenseVerificationException;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DefaultLicenseService
implements LicenseServiceInternal,
DcLicenseChecker {
    private static final Logger log = LoggerFactory.getLogger(DefaultLicenseService.class);
    private static final String BYPASS_DATA_CENTER_CHECK_PROPERTY_KEY = "confluence.bypass.data.center.check";
    private final LicenseManager decoder;
    private final LicenseStoreInternal store;
    private final AtlassianLicenseFactory licenseFactory;
    private final LicenseValidator validator;

    public DefaultLicenseService(LicenseStoreInternal store, LicenseManager decoder, LicenseValidator validator, AtlassianLicenseFactory licenseFactory) {
        this.store = (LicenseStoreInternal)Preconditions.checkNotNull((Object)store);
        this.decoder = (LicenseManager)Preconditions.checkNotNull((Object)decoder);
        this.validator = (LicenseValidator)Preconditions.checkNotNull((Object)validator);
        this.licenseFactory = (AtlassianLicenseFactory)Preconditions.checkNotNull((Object)licenseFactory);
    }

    @Override
    public @NonNull ConfluenceLicense retrieve() {
        return this.assertConfluenceLicense(this.store.retrieve());
    }

    @Override
    public @NonNull AtlassianLicense retrieveAtlassianLicense() throws LicenseException {
        return this.store.retrieve();
    }

    @Override
    public @NonNull Optional<ProductLicense> retrieveForProduct(Product product) {
        return Optional.ofNullable(this.store.retrieve().getProductLicense(product));
    }

    @Override
    public @NonNull ConfluenceLicense install(String licenseString) throws EmptyLicenseValidationException, ForgedLicenseException, KnownConfluenceLicenseValidationException {
        String sanitisedLicenseString = this.sanitise(licenseString);
        ConfluenceLicense license = this.validate(sanitisedLicenseString);
        this.store.install(sanitisedLicenseString);
        log.info("Installed license [..{}..], license version {}, created {}, expires {}, type {}, clustering enabled {}, description {}", new Object[]{DefaultLicenseService.getStringSnippet(licenseString, 50, 10), license.getLicenseVersion(), license.getCreationDate(), license.getExpiryDate(), license.getLicenseType().name(), license.isClusteringEnabled(), license.getDescription()});
        return license;
    }

    private static String getStringSnippet(String licenseString, int startIndex, int length) {
        int endIndex = startIndex + length;
        return licenseString.substring(Math.max(Math.min(licenseString.length(), endIndex) - length, 0), Math.min(licenseString.length(), endIndex));
    }

    @Override
    public boolean isLicensed() throws LicenseException {
        return this.store.retrieveOptional().isPresent();
    }

    @Override
    public boolean isLicensedForDataCenter() {
        return this.retrieve().isClusteringEnabled();
    }

    @Override
    public boolean isLicensedForDataCenterOrExempt() {
        ConfluenceLicense license = this.retrieve();
        return this.isLicensedForDataCenter() || "true".equals(license.getProperty(BYPASS_DATA_CENTER_CHECK_PROPERTY_KEY));
    }

    @Override
    public @NonNull ConfluenceLicense validate(String licenseString) throws EmptyLicenseValidationException, ForgedLicenseException, KnownConfluenceLicenseValidationException {
        return this.decodeAndValidate(this.sanitise(licenseString));
    }

    @Override
    public @NonNull ProductLicense validate(String licenseString, Product product) throws LicenseException, ForgedLicenseException {
        return this.assertProductLicense(this.decode(licenseString), product);
    }

    private ConfluenceLicense decodeAndValidate(String licenseString) throws ForgedLicenseException, KnownConfluenceLicenseValidationException {
        ConfluenceLicense license = this.assertConfluenceLicense(this.decode(licenseString));
        this.validator.validate(license);
        return license;
    }

    private AtlassianLicense decode(String licenseString) throws ForgedLicenseException {
        AtlassianLicense license;
        try {
            license = this.decodeAndValidateLicense(licenseString);
        }
        catch (LicenseException e) {
            log.warn(e.getMessage());
            throw new InvalidLicenseException(licenseString, e);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw e;
        }
        if (license == null) {
            throw new InvalidLicenseException("Decoded license was unexpectedly null for " + licenseString);
        }
        return license;
    }

    private String sanitise(String licenseString) throws EmptyLicenseValidationException {
        if (StringUtils.isEmpty((CharSequence)licenseString)) {
            throw new EmptyLicenseValidationException();
        }
        return licenseString.replaceAll("\\\\n\\\\", "");
    }

    private ConfluenceLicense assertConfluenceLicense(AtlassianLicense license) {
        ProductLicense productLicense = license.getProductLicense(Product.CONFLUENCE);
        if (productLicense == null) {
            throw new MissingConfluenceLicenseValidationException(license.getProductLicenses());
        }
        if (productLicense instanceof ConfluenceLicense) {
            ConfluenceLicense confLicense = (ConfluenceLicense)productLicense;
            return confLicense;
        }
        throw new IllegalStateException(String.format("Received an instance of [%s] which is not a child of [%s], either [%s] does not create this type anymore or it was not registered under %s [%s] in [%s].", license.getClass().getName(), ConfluenceLicense.class.getName(), ConfluenceProductLicenseFactory.class.getName(), Product.CONFLUENCE.getName(), Product.class.getName(), DefaultAtlassianLicenseFactory.class.getName()));
    }

    private ProductLicense assertProductLicense(AtlassianLicense license, Product product) {
        ProductLicense productLicense = license.getProductLicense(product);
        if (productLicense == null) {
            throw new InvalidLicenseException("Invalid license for " + product.getName());
        }
        return productLicense;
    }

    private AtlassianLicense decodeAndValidateLicense(@NonNull String licenseString) throws ForgedLicenseException {
        try {
            return this.decoder.getLicense(licenseString);
        }
        catch (LicenseVerificationException e) {
            Properties licenseProperties = e.getLicenseProperties();
            if (licenseProperties == null || licenseProperties.isEmpty()) {
                throw e;
            }
            AtlassianLicense decoded = this.licenseFactory.getLicense(licenseProperties);
            return this.getForgedLicense(decoded);
        }
        catch (LicenseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The provided license could not be decoded", e);
        }
    }

    private AtlassianLicense getForgedLicense(AtlassianLicense decode) throws ForgedLicenseException {
        ProductLicense productLicense = decode.getProductLicense(Product.CONFLUENCE);
        if (productLicense instanceof ConfluenceLicense) {
            throw new ForgedLicenseException();
        }
        return null;
    }

    public boolean isDcLicense() {
        return this.isLicensedForDataCenter();
    }
}

