/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.license;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.license.exception.EmptyLicenseValidationException;
import com.atlassian.confluence.license.exception.ForgedLicenseException;
import com.atlassian.confluence.license.exception.KnownConfluenceLicenseValidationException;
import com.atlassian.confluence.license.exception.LicenseException;
import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

@ParametersAreNonnullByDefault
public interface LicenseService {
    public @NonNull ConfluenceLicense retrieve() throws LicenseException;

    public @NonNull AtlassianLicense retrieveAtlassianLicense() throws LicenseException;

    public @NonNull Optional<ProductLicense> retrieveForProduct(Product var1);

    public @NonNull ConfluenceLicense validate(String var1) throws LicenseException, EmptyLicenseValidationException, ForgedLicenseException, KnownConfluenceLicenseValidationException;

    public @NonNull ProductLicense validate(String var1, Product var2) throws LicenseException, ForgedLicenseException;

    public @NonNull ConfluenceLicense install(String var1) throws LicenseException, EmptyLicenseValidationException, ForgedLicenseException, KnownConfluenceLicenseValidationException;

    public boolean isLicensedForDataCenter() throws LicenseException;

    public boolean isLicensedForDataCenterOrExempt() throws LicenseException;
}

