/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.license.util;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import java.util.Date;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
@Internal
public class ConfluenceLicenseUtils {
    private static final long UPDATE_ALLOWED_PERIOD = 31622400000L;
    private static final long ALMOST_EXPIRED_PERIOD = 3628800000L;
    private static final int YEAR_ATLASSIAN_FOUNDED = 2002;
    public static final Product CONFLUENCE_QUESTION = new Product("Confluence Questions", "com.atlassian.confluence.plugins.confluence-questions", true);

    @Deprecated
    public static boolean isDataCenter(ConfluenceLicense license) {
        return license.isClusteringEnabled();
    }

    public static long getSupportPeriodEnd(ConfluenceLicense license) {
        DateTime when;
        Date maintenanceExpiryDate = license.getMaintenanceExpiryDate();
        boolean validMaintenanceExpiryDate = maintenanceExpiryDate == null ? false : (when = new DateTime((Object)maintenanceExpiryDate)).getYear() >= 2002;
        return validMaintenanceExpiryDate ? maintenanceExpiryDate.getTime() : license.getCreationDate().getTime() + 31622400000L;
    }

    public static long getSupportPeriodAlmostExpiredDate(ConfluenceLicense license) {
        return ConfluenceLicenseUtils.getSupportPeriodEnd(license) - 3628800000L;
    }
}

