/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.rest;

import com.atlassian.diagnostics.Alert;
import com.atlassian.diagnostics.AlertWithElisions;
import com.atlassian.diagnostics.Elisions;
import com.atlassian.diagnostics.internal.rest.RestAlertTrigger;
import com.atlassian.diagnostics.internal.rest.RestElisions;
import com.atlassian.diagnostics.internal.rest.RestIssue;
import com.atlassian.diagnostics.internal.rest.UncheckedJsonGenerator;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class RestAlert {
    private final Alert alert;
    private final Elisions elisions;
    private final Set<String> suppressedFields;

    public RestAlert(@Nonnull Alert alert, String ... suppressedFields) {
        Objects.requireNonNull(alert, "alert");
        Objects.requireNonNull(suppressedFields, "suppressedFields");
        this.alert = alert;
        this.elisions = alert instanceof AlertWithElisions ? (Elisions)((AlertWithElisions)alert).getElisions().orElse(null) : null;
        this.suppressedFields = ImmutableSet.copyOf((Object[])suppressedFields);
    }

    public void serialize(UncheckedJsonGenerator generator) {
        generator.writeStartObject();
        generator.writeNumberField("id", this.alert.getId());
        generator.writeStringField("nodeName", this.alert.getNodeName());
        if (!this.suppressedFields.contains("issue")) {
            generator.writeObjectField("issue", new RestIssue(this.alert.getIssue()));
        }
        generator.writeNumberField("timestamp", this.alert.getTimestamp().toEpochMilli());
        generator.writeObjectField("trigger", new RestAlertTrigger(this.alert.getTrigger()));
        Object details = this.alert.getDetails().orElse(null);
        if (details != null) {
            generator.writeObjectFieldStart("details");
            generator.writeRaw(RestAlert.stripObjectStartAndEnd(this.alert.getIssue().getJsonMapper().toJson(details)));
            generator.writeEndObject();
        }
        if (this.elisions != null) {
            generator.writeObjectField("elisions", new RestElisions(this.elisions));
        }
        generator.writeEndObject();
    }

    private static String stripObjectStartAndEnd(String json) {
        if (json != null && json.startsWith("{") && json.endsWith("}")) {
            return json.substring(1, json.length() - 1);
        }
        return json;
    }
}

