/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.rest;

import com.atlassian.diagnostics.internal.rest.RuntimeIOException;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.apache.commons.io.output.CloseShieldOutputStream;

public abstract class StreamingJsonOutput
implements StreamingOutput {
    public void write(OutputStream output) throws IOException, WebApplicationException {
        JsonGenerator generator = new ObjectMapper().disable(SerializationFeature.FLUSH_AFTER_WRITE_VALUE).getJsonFactory().createJsonGenerator((OutputStream)new CloseShieldOutputStream(output), JsonEncoding.UTF8);
        try {
            this.write(generator);
        }
        catch (RuntimeIOException e) {
            throw e.getCause();
        }
        finally {
            generator.flush();
        }
    }

    protected abstract void write(@Nonnull JsonGenerator var1) throws IOException, WebApplicationException;
}

