/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.user;

import com.atlassian.crowd.model.user.BaseImmutableUser;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.UserWithAttributes;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ImmutableTimestampedUserWithAttributes
extends BaseImmutableUser
implements UserWithAttributes,
TimestampedUser {
    private final Map<String, Set<String>> attributes;
    private final Date createdDate;
    private final Date updatedDate;

    private ImmutableTimestampedUserWithAttributes(Builder builder) {
        super(builder);
        this.attributes = builder.attributes;
        this.createdDate = builder.createdDate;
        this.updatedDate = builder.updatedDate;
    }

    public static Builder builder(TimestampedUser user, Map<String, Set<String>> attributes) {
        return new Builder(user, attributes);
    }

    @Nonnull
    public Set<String> getValues(String key) {
        return this.attributes.getOrDefault(key, new HashSet());
    }

    @Nullable
    public String getValue(String key) {
        Set<String> values = this.getValues(key);
        return values.isEmpty() ? null : values.iterator().next();
    }

    public Set<String> getKeys() {
        return this.attributes.keySet();
    }

    @Override
    public Date getCreatedDate() {
        return this.createdDate == null ? null : new Date(this.createdDate.getTime());
    }

    @Override
    public Date getUpdatedDate() {
        return this.updatedDate == null ? null : new Date(this.updatedDate.getTime());
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public ImmutableTimestampedUserWithAttributes withName(String name) {
        return (ImmutableTimestampedUserWithAttributes)ImmutableTimestampedUserWithAttributes.builder(this, this.attributes).name(name).build();
    }

    public static class Builder
    extends BaseImmutableUser.Builder<ImmutableTimestampedUserWithAttributes> {
        private Map<String, Set<String>> attributes;
        private Date createdDate;
        private Date updatedDate;

        public Builder(TimestampedUser user, Map<String, Set<String>> attributes) {
            super(user);
            this.setAttributes(attributes);
            this.setCreatedDate(user.getCreatedDate());
            this.setUpdatedDate(user.getUpdatedDate());
        }

        public Builder setAttributes(Map<String, Set<String>> attributes) {
            this.attributes = new HashMap<String, Set<String>>(attributes);
            return this;
        }

        public Builder setCreatedDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public Builder setUpdatedDate(Date updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        @Override
        public ImmutableTimestampedUserWithAttributes build() {
            return new ImmutableTimestampedUserWithAttributes(this);
        }
    }
}

