/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.db.config.password;

import com.atlassian.db.config.password.Cipher;
import com.atlassian.db.config.password.CipherProvider;
import com.atlassian.db.config.password.ciphers.base64.Base64Cipher;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCipherProvider
implements CipherProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultCipherProvider.class);

    @Override
    public String getDefaultCipherProviderClassName() {
        return Base64Cipher.class.getCanonicalName();
    }

    @Override
    public Optional<Cipher> getInstance(String cipherProviderClassName) {
        log.debug("Initiate cipher provider class: " + cipherProviderClassName);
        if (cipherProviderClassName == null || cipherProviderClassName.isEmpty()) {
            return Optional.empty();
        }
        try {
            Class<?> cipherProviderClass = Class.forName(cipherProviderClassName);
            Cipher provider = (Cipher)cipherProviderClass.newInstance();
            return Optional.of(provider);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException classInitException) {
            log.error("Couldn't initiate class: " + cipherProviderClassName, (Throwable)classInitException);
            throw new IllegalArgumentException(classInitException);
        }
    }
}

