/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.tunnel.dev.DevUtils;
import com.atlassian.tunnel.process.InletsClientManager;
import com.atlassian.tunnel.scheduled.TunnelScheduledJob;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(PluginLifecycleListener.class);
    private final InletsClientManager inletsClientManager;
    private final EventPublisher eventPublisher;
    private final List<TunnelScheduledJob> scheduledJobs;

    @PostConstruct
    public void init() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent pluginEnabledEvent) {
        if ("com.atlassian.securetunnel.client.tunnel-client-plugin".equals(pluginEnabledEvent.getPlugin().getKey())) {
            try {
                this.scheduledJobs.forEach(TunnelScheduledJob::schedule);
                if (DevUtils.isDevMode()) {
                    log.debug("Not starting Tunnel Client on plugin startup as Dev Mode is enabled");
                } else {
                    log.debug("Starting Tunnel Client on plugin enabled");
                    this.inletsClientManager.start();
                }
            }
            catch (Exception e) {
                log.warn("An exception occurred while starting Secure Tunnel Client on plugin enabled: {}", (Object)e.getMessage());
                log.debug("Details: ", (Throwable)e);
            }
        }
    }

    @EventListener
    public void onPluginDisabling(PluginDisablingEvent pluginDisablingEvent) {
        if ("com.atlassian.securetunnel.client.tunnel-client-plugin".equals(pluginDisablingEvent.getPlugin().getKey())) {
            log.debug("Stopping Tunnel Client on plugin disabled");
            this.inletsClientManager.stop();
            this.scheduledJobs.forEach(TunnelScheduledJob::unschedule);
        }
    }

    @Generated
    public PluginLifecycleListener(InletsClientManager inletsClientManager, EventPublisher eventPublisher, List<TunnelScheduledJob> scheduledJobs) {
        this.inletsClientManager = inletsClientManager;
        this.eventPublisher = eventPublisher;
        this.scheduledJobs = scheduledJobs;
    }
}

