/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.configuration.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.tunnel.configuration.Tunnel;
import com.atlassian.tunnel.configuration.dao.TunnelDao;
import com.atlassian.tunnel.configuration.dao.TunnelEntity;
import com.atlassian.tunnel.configuration.dao.TunnelEntityMapper;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import net.java.ao.RawEntity;

public class ActiveObjectsTunnelDao
implements TunnelDao {
    private final ActiveObjects activeObjects;

    @Override
    public Optional<Tunnel> getTunnel() {
        return this.findFirstTunnel().map(TunnelEntityMapper::mapEntity);
    }

    @Override
    public Tunnel saveTunnel(Tunnel tunnel) {
        Optional<TunnelEntity> tunnelEntity = this.findFirstTunnel();
        if (tunnelEntity.isPresent()) {
            this.saveTunnelUpdate(tunnelEntity.get(), tunnel);
            return TunnelEntityMapper.mapEntity(tunnelEntity.get());
        }
        TunnelEntity savedTunnel = (TunnelEntity)this.activeObjects.create(TunnelEntity.class, TunnelEntityMapper.mapToTunnelEntityParametersFrom(tunnel));
        return TunnelEntityMapper.mapEntity(savedTunnel);
    }

    @Override
    public void deleteTunnel() {
        Optional<TunnelEntity> tunnelEntity = this.findFirstTunnel();
        tunnelEntity.ifPresent(xva$0 -> this.activeObjects.delete(new RawEntity[]{xva$0}));
    }

    @Override
    public void syncTunnel() {
    }

    @Override
    public void reloadTunnelCaches() {
    }

    private Optional<TunnelEntity> findFirstTunnel() {
        return Arrays.stream((TunnelEntity[])this.activeObjects.find(TunnelEntity.class)).findFirst();
    }

    private void saveTunnelUpdate(TunnelEntity entity, Tunnel newTunnel) {
        entity.setName(newTunnel.getName());
        entity.setCloudOrgName(newTunnel.getCloudOrgName());
        entity.setCloudPageUrl(newTunnel.getCloudPageUrl());
        entity.setUpstreamDnsUrl(newTunnel.getUpstreamDnsUrl());
        entity.setToken(newTunnel.getToken());
        entity.save();
    }

    @Generated
    public ActiveObjectsTunnelDao(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }
}

