/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.configuration.dao;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.tunnel.configuration.Tunnel;
import com.atlassian.tunnel.configuration.dao.TunnelDao;
import com.atlassian.tunnel.process.event.TunnelReloadedEvent;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedTunnelDao
implements TunnelDao {
    private static final Logger log = LoggerFactory.getLogger(CachedTunnelDao.class);
    protected static final String LOCAL_CACHE_SUFFIX = "_Local";
    private static final int MAXIMUM_CACHE_ENTRIES = 1;
    private final TunnelDao tunnelDao;
    private final EventPublisher eventPublisher;
    private final ExecutorService executorService;
    private final CachedReference<Optional<Tunnel>> remoteCachedTunnel;
    private final CachedReference<Optional<Tunnel>> localCachedTunnel;

    public CachedTunnelDao(TunnelDao tunnelDao, CacheManager cacheManager, EventPublisher eventPublisher, ExecutorService executorService) {
        this.tunnelDao = tunnelDao;
        this.eventPublisher = eventPublisher;
        this.executorService = executorService;
        this.remoteCachedTunnel = cacheManager.getCachedReference(Tunnel.class.getName(), tunnelDao::getTunnel, new CacheSettingsBuilder().remote().replicateViaInvalidation().replicateAsynchronously().maxEntries(1).build());
        this.localCachedTunnel = cacheManager.getCachedReference(Tunnel.class.getName() + LOCAL_CACHE_SUFFIX, this::populateLocalTunnelCache, new CacheSettingsBuilder().local().maxEntries(1).build());
    }

    @Override
    public Optional<Tunnel> getTunnel() {
        return (Optional)this.remoteCachedTunnel.get();
    }

    @Override
    public Tunnel saveTunnel(Tunnel tunnel) {
        Tunnel savedTunnel = this.tunnelDao.saveTunnel(tunnel);
        this.reloadTunnelCaches();
        return savedTunnel;
    }

    @Override
    public void deleteTunnel() {
        this.tunnelDao.deleteTunnel();
        this.reloadTunnelCaches();
    }

    @Override
    public void syncTunnel() {
        if (this.areCachesDifferent()) {
            this.reloadTunnelCaches();
        }
    }

    Optional<Tunnel> populateLocalTunnelCache() {
        log.debug("Local cached tunnel reloaded");
        Optional<Tunnel> tunnel = this.tunnelDao.getTunnel();
        this.eventPublisher.publish((Object)new TunnelReloadedEvent());
        return tunnel;
    }

    @Override
    public void reloadTunnelCaches() {
        this.executorService.execute(() -> {
            this.remoteCachedTunnel.reset();
            this.localCachedTunnel.reset();
            this.remoteCachedTunnel.get();
            this.localCachedTunnel.get();
        });
    }

    private boolean areCachesDifferent() {
        return !this.getLocalCachedTunnel().equals(this.remoteCachedTunnel.get());
    }

    private Optional<Tunnel> getLocalCachedTunnel() {
        return (Optional)this.localCachedTunnel.get();
    }
}

