/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.configuration.rest;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.tunnel.configuration.Tunnel;
import com.atlassian.tunnel.configuration.TunnelConfigurationKeyDecoder;
import com.atlassian.tunnel.configuration.TunnelService;
import com.atlassian.tunnel.configuration.rest.RestCreatedTunnelInformation;
import com.atlassian.tunnel.configuration.rest.RestEncodedTunnelConfigurationKey;
import com.atlassian.tunnel.configuration.rest.RestRefreshToken;
import com.atlassian.tunnel.configuration.rest.RestTunnel;
import com.atlassian.tunnel.monitoring.TunnelConnectionService;
import com.atlassian.tunnel.monitoring.rest.RestTunnelConnection;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/tunnel")
@SystemAdminOnly
public class TunnelController {
    private static final Logger log = LoggerFactory.getLogger(TunnelController.class);
    private final TunnelService tunnelService;
    private final TunnelConnectionService tunnelConnectionService;
    private final TunnelConfigurationKeyDecoder tunnelConfigurationKeyDecoder;

    @Inject
    public TunnelController(TunnelService tunnelService, TunnelConnectionService tunnelConnectionService, TunnelConfigurationKeyDecoder tunnelConfigurationKeyDecoder) {
        this.tunnelService = tunnelService;
        this.tunnelConnectionService = tunnelConnectionService;
        this.tunnelConfigurationKeyDecoder = tunnelConfigurationKeyDecoder;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getTunnel() {
        log.trace("Retrieving tunnel");
        Optional<Tunnel> tunnel = this.tunnelService.getTunnel();
        if (!tunnel.isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)this.createRestTunnel(tunnel.get())).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateTunnelWithKey(RestEncodedTunnelConfigurationKey restKey) {
        TunnelConfigurationKeyDecoder.TunnelConfigurationKey decodedKey = this.tunnelConfigurationKeyDecoder.decode(restKey.getKey());
        return this.updateTunnelResponse(Tunnel.fromKey(decodedKey)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/token")
    public Response refreshTunnelToken(RestRefreshToken refreshToken) {
        return this.tunnelService.getTunnel().map(tunnel -> this.updateTunnelResponse(tunnel.toBuilder().token(refreshToken.getToken()).build())).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND)).build();
    }

    private Response.ResponseBuilder updateTunnelResponse(Tunnel tunnel) {
        return this.tunnelService.updateTunnel(tunnel).map(RestCreatedTunnelInformation::mapFrom).map(Response::ok).orElseGet(Response::noContent);
    }

    @DELETE
    public Response deleteTunnel() {
        log.trace("Deleting tunnel");
        this.tunnelService.deleteTunnel();
        return Response.noContent().build();
    }

    private RestTunnel createRestTunnel(Tunnel tunnel) {
        return new RestTunnel(tunnel.getName(), tunnel.getCloudOrgName(), tunnel.getCloudPageUrl(), this.tunnelService.getTunnelStatus().name(), this.tunnelConnectionService.getTunnelConnections().stream().map(RestTunnelConnection::mapFrom).collect(Collectors.toList()));
    }
}

