/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.configuration.scheduled;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.tunnel.configuration.TunnelService;
import com.atlassian.tunnel.properties.TunnelProperties;
import com.atlassian.tunnel.scheduled.TunnelScheduledJob;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelRefreshJob
implements TunnelScheduledJob {
    private static final Logger log = LoggerFactory.getLogger(TunnelRefreshJob.class);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)TunnelRefreshJob.class.getName());
    private static final JobId JOB_ID = JobId.of((String)TunnelRefreshJob.class.getSimpleName());
    private final TunnelService tunnelService;
    private final TunnelProperties tunnelProperties;
    private final SchedulerService schedulerService;

    @Override
    public void schedule() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new TunnelRefreshJobRunner());
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(this.createSchedule());
        try {
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
        }
        catch (SchedulerServiceException e) {
            log.error("Could not schedule job {}", (Object)TunnelRefreshJob.class.getName());
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unschedule() {
        this.schedulerService.unscheduleJob(JOB_ID);
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private Schedule createSchedule() {
        Date firstRunTime = Date.from(Instant.now().plus(Duration.ofMillis(this.tunnelProperties.getConfigRefreshInitialWait())));
        return Schedule.forInterval((long)this.tunnelProperties.getConfigRefreshInterval(), (Date)firstRunTime);
    }

    @Generated
    public TunnelRefreshJob(TunnelService tunnelService, TunnelProperties tunnelProperties, SchedulerService schedulerService) {
        this.tunnelService = tunnelService;
        this.tunnelProperties = tunnelProperties;
        this.schedulerService = schedulerService;
    }

    public class TunnelRefreshJobRunner
    implements JobRunner {
        @Nullable
        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            this.refreshTunnel();
            return JobRunnerResponse.success();
        }

        private void refreshTunnel() {
            log.trace("{} running", (Object)this.getClass().getName());
            try {
                TunnelRefreshJob.this.tunnelService.syncTunnel();
            }
            catch (Exception e) {
                log.error("Error refreshing tunnel", (Throwable)e);
            }
            log.trace("{} completed", (Object)this.getClass().getName());
        }
    }
}

