/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.file;

import com.atlassian.tunnel.file.InletsExecutable;
import com.atlassian.tunnel.file.LinuxInletsExecutable;
import com.atlassian.tunnel.file.MacOsInletsExecutable;
import com.atlassian.tunnel.file.TunnelWorkingDirectoryProvider;
import com.atlassian.tunnel.file.WindowsInletsExecutable;
import com.atlassian.tunnel.properties.OperatingSystemProvider;
import com.atlassian.tunnel.properties.exception.InvalidOperatingSystemException;
import java.io.IOException;
import java.nio.file.Path;

public class InletsExecutableFactory {
    private final TunnelWorkingDirectoryProvider tunnelWorkingDirectoryProvider;
    private final OperatingSystemProvider operatingSystemProvider;

    public InletsExecutableFactory(TunnelWorkingDirectoryProvider tunnelWorkingDirectoryProvider, OperatingSystemProvider operatingSystemProvider) {
        this.tunnelWorkingDirectoryProvider = tunnelWorkingDirectoryProvider;
        this.operatingSystemProvider = operatingSystemProvider;
    }

    public InletsExecutable create() throws IOException, InvalidOperatingSystemException {
        Path workingDirectory = this.tunnelWorkingDirectoryProvider.getPath();
        return this.buildExecutable(workingDirectory);
    }

    private InletsExecutable buildExecutable(Path workingDirectory) throws IOException, InvalidOperatingSystemException {
        OperatingSystemProvider.OperatingSystem os = this.operatingSystemProvider.getOperatingSystem();
        if (os == OperatingSystemProvider.OperatingSystem.LINUX) {
            return new LinuxInletsExecutable(workingDirectory);
        }
        if (os == OperatingSystemProvider.OperatingSystem.WINDOWS) {
            return new WindowsInletsExecutable(workingDirectory);
        }
        if (os == OperatingSystemProvider.OperatingSystem.MAC_OS) {
            return new MacOsInletsExecutable(workingDirectory);
        }
        throw new InvalidOperatingSystemException();
    }
}

