/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.file;

import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class TunnelWorkingDirectoryProvider {
    static final String TUNNEL_PLUGIN_WORKING_DIRECTORY = "secure-tunnel";
    private final ApplicationProperties applicationProperties;

    public TunnelWorkingDirectoryProvider(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public Path getPath() throws IOException {
        Path workingDirectory = this.applicationProperties.getLocalHomeDirectory().map(path -> path.resolve(TUNNEL_PLUGIN_WORKING_DIRECTORY)).orElseThrow(() -> new IOException("Could not create working directory, local home is not defined."));
        if (Files.notExists(workingDirectory, new LinkOption[0])) {
            Files.createDirectory(workingDirectory, new FileAttribute[0]);
        }
        return workingDirectory;
    }
}

