/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.filters;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.sal.api.features.DarkFeatureManager;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class TunnelDiagnosticFilter
implements Filter {
    private final DarkFeatureManager darkFeatureManager;
    private static final Logger log = LoggerFactory.getLogger(TunnelDiagnosticFilter.class);
    @VisibleForTesting
    static final String DISABLE_TUNNEL_DIAGNOSTICS = "atlassian.tunnel.client.disable.tunnel.diagnostics";
    private static final String HOST_NAME = "original-host";
    private final Pattern regex = Pattern.compile(".+\\.self-hosted\\.(stg\\.|dev\\.)?atlassian\\.com");

    public TunnelDiagnosticFilter(DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = darkFeatureManager;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        String header = httpRequest.getHeader(HOST_NAME);
        long startTime = System.currentTimeMillis();
        filterChain.doFilter(servletRequest, servletResponse);
        if (!this.darkFeatureManager.isEnabledForAllUsers(DISABLE_TUNNEL_DIAGNOSTICS).orElse(false).booleanValue() && header != null && this.regex.matcher(header).find()) {
            long endTime = System.currentTimeMillis();
            long timeOfProcessing = endTime - startTime;
            String requestId = httpRequest.getHeader("x-request-id");
            log.debug("Request with requestId={} was processed in {} seconds", (Object)requestId, (Object)timeOfProcessing);
            if (timeOfProcessing > Duration.of(20L, ChronoUnit.SECONDS).toMillis()) {
                log.warn("Processing the request took more than 20 seconds. RequestId={}, time={}", (Object)requestId, (Object)timeOfProcessing);
            }
            ((HttpServletResponse)servletResponse).addHeader("X-RequestTimeTakenDiagnostic", Long.toString(timeOfProcessing));
            ((HttpServletResponse)servletResponse).addHeader("X-RequestTimeReceived", Long.toString(startTime));
        }
    }

    public void destroy() {
    }
}

