/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.monitoring.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.tunnel.monitoring.TunnelConnection;
import com.atlassian.tunnel.monitoring.dao.TunnelConnectionDao;
import com.atlassian.tunnel.monitoring.dao.TunnelConnectionEntity;
import com.atlassian.tunnel.monitoring.dao.TunnelStatusEntityMapper;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class ActiveObjectsTunnelConnectionDao
implements TunnelConnectionDao {
    private final ActiveObjects activeObjects;

    @Override
    public List<TunnelConnection> getTunnelConnections() {
        return Arrays.stream((TunnelConnectionEntity[])this.activeObjects.find(TunnelConnectionEntity.class)).map(TunnelStatusEntityMapper::mapEntity).collect(Collectors.toList());
    }

    @Override
    public void saveTunnelConnection(TunnelConnection tunnelConnection) {
        Optional<TunnelConnectionEntity> tunnelConnectionEntity = Arrays.stream((TunnelConnectionEntity[])this.activeObjects.find(TunnelConnectionEntity.class, this.whereNodeIdEquals(tunnelConnection.getNodeId()))).findFirst();
        if (tunnelConnectionEntity.isPresent()) {
            this.saveTunnelConnectionUpdate(tunnelConnectionEntity.get(), tunnelConnection);
        } else {
            this.activeObjects.create(TunnelConnectionEntity.class, TunnelStatusEntityMapper.mapToTunnelConnectionEntityParametersFrom(tunnelConnection));
        }
    }

    @Override
    public void deleteAllTunnelConnections() {
        Arrays.stream((TunnelConnectionEntity[])this.activeObjects.find(TunnelConnectionEntity.class)).forEach(xva$0 -> this.activeObjects.delete(new RawEntity[]{xva$0}));
    }

    @Override
    public void deleteTunnelConnectionByNodeId(String nodeId) {
        Arrays.stream((TunnelConnectionEntity[])this.activeObjects.find(TunnelConnectionEntity.class, this.whereNodeIdEquals(nodeId))).findFirst().ifPresent(xva$0 -> this.activeObjects.delete(new RawEntity[]{xva$0}));
    }

    private void saveTunnelConnectionUpdate(TunnelConnectionEntity entity, TunnelConnection newTunnelConnection) {
        entity.setNodeId(newTunnelConnection.getNodeId());
        entity.setStatus(newTunnelConnection.getStatus().name());
        entity.setRetryCount(newTunnelConnection.getRetryCount());
        entity.save();
    }

    private Query whereNodeIdEquals(String nodeId) {
        return Query.select().where("NODE_ID = ?", new Object[]{nodeId});
    }

    @Generated
    public ActiveObjectsTunnelConnectionDao(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }
}

