/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.process.retry;

import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BackoffHandler {
    private static final Logger log = LoggerFactory.getLogger(BackoffHandler.class);
    protected static final double RANDOMIZATION_FACTOR = 0.3;
    private static final long INITIAL_INTERVAL = 1500L;
    private static final int MAX_RETRIES = 30;

    private BackoffHandler() {
    }

    public static long determineWaitTime(int previousRetries, boolean isUnauthorized) {
        int multiplier = isUnauthorized ? 2 : 1;
        int retryCount = Math.max(Math.min(previousRetries, 30), 0);
        long waitTime = (long)(1500.0 * Math.pow(1.2, retryCount)) * (long)multiplier;
        long waitTimeIncludingJitter = BackoffHandler.applyJitter(waitTime);
        log.debug("Backoff wait time: {}", (Object)waitTimeIncludingJitter);
        return waitTimeIncludingJitter;
    }

    private static long applyJitter(long current) {
        long delta = (long)(0.3 * (double)current);
        return ThreadLocalRandom.current().nextLong(current - delta, current + delta);
    }
}

