/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.spring.product;

import com.atlassian.audit.api.AuditService;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.BitbucketOnly;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.tunnel.audit.DefaultTunnelAuditService;
import com.atlassian.tunnel.audit.TunnelAuditService;
import com.atlassian.tunnel.cluster.BitbucketNodeIdProvider;
import com.atlassian.tunnel.cluster.NodeIdProvider;
import com.atlassian.tunnel.properties.BitbucketTunnelProperties;
import com.atlassian.tunnel.properties.TunnelProperties;
import com.atlassian.tunnel.web.loopsprevention.NoopRedirectsLoopPreventer;
import com.atlassian.tunnel.web.loopsprevention.RedirectsLoopPreventer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={BitbucketOnly.class})
public class BitbucketConfiguration {
    @Bean
    public NodeIdProvider bitbucketNodeIdProvider(ClusterService clusterService) {
        return new BitbucketNodeIdProvider(clusterService);
    }

    @Bean
    public RedirectsLoopPreventer bitbucketRedirectsLoopPreventer() {
        return new NoopRedirectsLoopPreventer();
    }

    @Bean
    public TunnelProperties bitbucketTunnelProperties(ApplicationProperties applicationProperties) {
        return new BitbucketTunnelProperties(applicationProperties);
    }

    @Bean
    public ClusterService clusterService() {
        return OsgiServices.importOsgiService(ClusterService.class);
    }

    @Bean
    public TunnelAuditService tunnelAuditService(I18nResolver i18nResolver) {
        return new DefaultTunnelAuditService(OsgiServices.importOsgiService(AuditService.class), i18nResolver);
    }
}

