/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.spring.product;

import com.atlassian.audit.api.AuditService;
import com.atlassian.cluster.monitoring.spi.ClusterMonitoring;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.ConfluenceOnly;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.tunnel.audit.DefaultTunnelAuditService;
import com.atlassian.tunnel.audit.TunnelAuditService;
import com.atlassian.tunnel.cluster.DefaultNodeIdProvider;
import com.atlassian.tunnel.cluster.NodeIdProvider;
import com.atlassian.tunnel.properties.DefaultTunnelProperties;
import com.atlassian.tunnel.properties.TunnelProperties;
import com.atlassian.tunnel.web.loopsprevention.RedirectsLoopPreventer;
import com.atlassian.tunnel.web.loopsprevention.SeraphRedirectsLoopPreventer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={ConfluenceOnly.class})
public class ConfluenceConfiguration {
    @Bean
    public ClusterMonitoring clusterMonitoring() {
        return OsgiServices.importOsgiService(ClusterMonitoring.class);
    }

    @Bean
    public NodeIdProvider confluenceNodeIdProvider(ClusterMonitoring clusterMonitoring) {
        return new DefaultNodeIdProvider(clusterMonitoring);
    }

    @Bean
    public RedirectsLoopPreventer seraphRedirectsLoopPreventer() {
        return new SeraphRedirectsLoopPreventer();
    }

    @Bean
    public TunnelAuditService tunnelAuditService(I18nResolver i18nResolver) {
        return new DefaultTunnelAuditService(OsgiServices.importOsgiService(AuditService.class), i18nResolver);
    }

    @Bean
    public TunnelProperties tunnelProperties() {
        return new DefaultTunnelProperties();
    }
}

